% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-cards.R
\name{autocomplete_name}
\alias{autocomplete_name}
\title{Autocomplete the name of a card}
\usage{
autocomplete_name(name, include_extras = FALSE)
}
\arguments{
\item{name}{A string with a card's name (or part of it). See details.}

\item{include_extras}{If \code{TRUE}, extra cards (tokens, planes, etc) will be
included.}
}
\value{
A string vector.
}
\description{
Returns a string vector of up to 20 full English card names that could be
autocompletions of the given \code{name} argument.
}
\details{
The names are sorted with the nearest match first, highly favoring results
that begin with your given string.

Spaces, punctuation, and capitalization are ignored.

If \code{name} is less than 2 characters long, or if no names match, the vector
will contain 0 elements (instead of returning any errors).
}
\examples{
\donttest{
# Get all related card names
autocomplete_name("falken")
}

}
\references{
\url{https://scryfall.com/docs/api/cards/autocomplete}
}
