% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oversample.R
\name{oversample_smote}
\alias{oversample_smote}
\title{Oversample a dataset by SMOTE.}
\usage{
oversample_smote(data, cls, cls_col, m, k = NA)
}
\arguments{
\item{data}{Dataset to be oversampled.}

\item{cls}{Class to be oversampled.}

\item{cls_col}{Column containing class information.}

\item{m}{Desired number of samples in the oversampled data.}

\item{k}{Number of neighbors used in \code{\link[smotefamily]{SMOTE}()} to generate synthetic minority instances. This value must be smaller than the number of minority instances already present for a given class. If \code{NA}, \code{min(5, n-1)} is chosen, where n is the number of instances of the minority class.}
}
\value{
The oversampled dataset.
}
\description{
Oversample a dataset by SMOTE.
}
\examples{
table(iris$Species)
smoted <- oversample_smote(iris, "setosa", "Species", 100)
nrow(smoted)
}
