% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theta_linear.r
\name{get_theta_linear}
\alias{get_theta_linear}
\title{Find Scale Parameter for Inverse Gamma Hyperprior of Linear Effects with Spike and Slab Prior}
\usage{
get_theta_linear(alpha1 = 0.1, alpha2 = 0.1, c1 = 0.1, c2 = 0.1,
  eps = .Machine$double.eps, v1 = 5)
}
\arguments{
\item{alpha1}{denotes the 1-\eqn{\alpha_1} level for \eqn{v_2}.}

\item{alpha2}{denotes the 1-\eqn{\alpha_2} level for \eqn{r}.}

\item{c1}{denotes the expected range of the linear effect in the slab part.}

\item{c2}{denotes the expected range of the linear effect in the spike part.}

\item{eps}{denotes the error tolerance of the result, default is \code{.Machine$double.eps}.}

\item{v1}{is the shape parameter of the inverse gamma distribution, default is 5.}
}
\value{
an object of class \code{list} with values from \code{\link{uniroot}}.
}
\description{
This function implements a optimisation routine that computes the scale parameter \eqn{v_2} and selection parameter
\eqn{r} of the inverse gamma prior IG(\eqn{v_1},\eqn{v_2}) for \eqn{\tau^2} when \eqn{\tau^2\sim N(0,r(\delta)\tau^2)} 
and given shape paramter 
such that approximately \eqn{P(\beta\le c_2|spike)\ge 1-\alpha_2} and \eqn{P(\beta\ge c_1|slab)\ge 1-\alpha1}.\cr
\eqn{\alpha_1} and \eqn{\alpha_2} should not be smaller than 0.1 due to numerical sensitivity and possible instability. Better change \eqn{c_1}, \eqn{c_2}.
}
\section{Warning}{

\eqn{\alpha_1} and \eqn{\alpha_2} should not be smaller than 0.1 due to numerical sensitivity and possible instability. Better change \eqn{c_1}, \eqn{c_2}.
}

\examples{
set.seed(123)
result <- get_theta_linear()
r <- result$r
v2 <- result$v2

get_theta_linear(alpha1=0.1,alpha2=0.1,c1=0.5,c2=0.1,v1=5) 

}
\references{
Nadja Klein, Thomas Kneib, Stefan Lang and Helga Wagner (2016). Automatic Effect Selection in Distributional Regression via Spike and Slab Priors. 
\emph{Working Paper}.
}
\author{
Nadja Klein
}
