% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aedecod.R
\name{check_ae_aedecod}
\alias{check_ae_aedecod}
\title{Check for missing AEDECOD values}
\usage{
check_ae_aedecod(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AETERM, AEDECOD}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check looks for missing AEDECOD values
}
\examples{

AE <- data.frame(
 USUBJID = 1:5,
 DOMAIN = c(rep("AE", 5)),
 AESEQ = 1:5,
 AESTDTC = 1:5,
 AETERM = 1:5,
 AEDECOD = 1:5,
  AESPID = c("FORMNAME-R:13/L:13XXXX",
             "FORMNAME-R:16/L:16XXXX",
             "FORMNAME-R:2/L:2XXXX",
             "FORMNAME-R:19/L:19XXXX",
             "FORMNAME-R:5/L:5XXXX"),
 stringsAsFactors = FALSE
)

check_ae_aedecod(AE)

AE$AEDECOD[1] = NA
AE$AEDECOD[2] = "NA"
AE$AEDECOD[3:5] = ""
check_ae_aedecod(AE)
check_ae_aedecod(AE,preproc=roche_derive_rave_row)

AE$AEDECOD <- NULL
check_ae_aedecod(AE)

}
\author{
Yinghui Miao, Stella Banjo(HackR 2021)
}
