% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aeout_aeendtc_aedthdtc.R
\name{check_ae_aeout_aeendtc_aedthdtc}
\alias{check_ae_aeout_aeendtc_aedthdtc}
\title{Check for AE outcome (AEOUT) of 'FATAL' with non-missing resolution
date that is not equal to the death date}
\usage{
check_ae_aeout_aeendtc_aedthdtc(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AETERM,
AEDTHDTC, AEENDTC, AEOUT}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for AEs with outcome of 'FATAL' but AE
resolution date is not equal to AE death date.
Note that these datapoints are not collected the same way for all trials -
some trials leave AEENDTC missing if it was unresolved at death date. Confirm
within your team before querying this issue.
}
\examples{

AE <- data.frame(
    USUBJID = 1:10,
    DOMAIN = "AE",
    AEDTHDTC = c(NA, "NA", rep("2015-03-12",4), NA, NA, "2020-01-01", ""),
    AEENDTC = c(NA, "NA", rep("2015-03-12",4), NA, "2020-01-01", NA, ""),
    AEOUT = c("", "", "","FATAL","RECOVERED/RESOLVED", rep("FATAL",5)),
    AETERM = 1:10,
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

check_ae_aeout_aeendtc_aedthdtc(AE)
check_ae_aeout_aeendtc_aedthdtc(AE,preproc=roche_derive_rave_row)

AE$AESPID <- NULL
check_ae_aeout_aeendtc_aedthdtc(AE)

AE$AEDTHDTC <- NULL
AE$AEOUT <- NULL
check_ae_aeout_aeendtc_aedthdtc(AE)

}
\author{
Sara Bodach, Stella Banjo(HackR 2021)
}
