% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cm_cmindc.R
\name{check_cm_cmindc}
\alias{check_cm_cmindc}
\title{Check for concomitant medication indication with text string "PROPHYL"
when not given for prophylaxis}
\usage{
check_cm_cmindc(CM, preproc = identity, ...)
}
\arguments{
\item{CM}{Concomitant Medication SDTM dataset with variables USUBJID, CMTRT,
CMSTDTC, CMINDC, CMPROPH, CMSPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for patients with text string "PROPHYL" in CMINDC
when CMPROPH is not checked as "Y" in studies with given for prophylaxis
variable (CMPROPH)
}
\examples{

CM <- data.frame(
 USUBJID = c(rep(1,3),rep(2,3),rep(3,3)),
 CMTRT = letters[1:9],
 CMSTDTC = rep("2017-01-01",9),
 CMINDC = c(rep("INDICATION 1",2), rep("indication 2",2),
            rep("Prophylaxis",2),rep("PROPHYLACTIC",2),"PROPHYLAXIS FOR XYZ"),
 CMPROPH = c(rep("Y",3),rep(NA,2),rep("",2),"NA","."),
 CMSPID = "/F:XXX-D:12345-R:123",
 stringsAsFactors=FALSE
)

check_cm_cmindc(CM)
check_cm_cmindc(CM,preproc=roche_derive_rave_row)

CM$CMPROPH[7] = "Y"
check_cm_cmindc(CM)

CM$CMSPID = NULL
check_cm_cmindc(CM,preproc=roche_derive_rave_row)

CM$CMPROPH = NULL
check_cm_cmindc(CM)


}
\author{
Sara Bodach, Stella Banjo (HackR 2021)
}
