% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_exoccur_exdose_exstdtc.R
\name{check_ex_exoccur_exdose_exstdtc}
\alias{check_ex_exoccur_exdose_exstdtc}
\title{Check for Invalid EXDOSE (Dose per Administration) and
Missing/Incomplete EXSTDTC (Start Date) Values for valid exposures}
\usage{
check_ex_exoccur_exdose_exstdtc(EX)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID, VISIT, VISITNUM,
EXOCCUR, EXTRT, EXDOSE, EXSTDTC and EXENDTC}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for valid exposures (EXOCCUR=Y or doesn't exist) but
EXDOSE (dose per administration) is not > 0 (>= 0 in case of placebo) and/or
EXSTDTC (start date/treatment date) is missing or incomplete in the EX
(exposure) SDTM domain
}
\examples{

EX <- data.frame(USUBJID = LETTERS[1:5],
                 VISIT = paste0("Visit ", 1:5),
                 VISITNUM = 1:5,
                 EXOCCUR = c('Y', rep('', 4)),
                 EXTRT = LETTERS[1:5],
                 EXDOSE = 1:5,
                 EXSTDTC = c('2010-01-01', rep('', 4)),
                 EXENDTC = c('2010-01-01', rep('', 4)),
                 stringsAsFactors = FALSE)

EX$EXOCCUR[2] <- 'Y'
EX$EXSTDTC[2] <- '2011'
EX$EXDOSE[1] <- 0

check_ex_exoccur_exdose_exstdtc(EX)

EX$VISIT <- NULL

check_ex_exoccur_exdose_exstdtc(EX)


}
\author{
Sara Bodach
}
