% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_exoccur_mis_exdose_nonmis.R
\name{check_ex_exoccur_mis_exdose_nonmis}
\alias{check_ex_exoccur_mis_exdose_nonmis}
\title{Check for missing EXOCCUR but EXDOSE not missing}
\usage{
check_ex_exoccur_mis_exdose_nonmis(EX)
}
\arguments{
\item{EX}{Exposure dataframe with variables USUBJID, EXTRT, EXDOSE, EXOCCUR, EXSTDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Checks for exposure records with missing EXOCCUR but EXDOSE not missing
}
\examples{

 EX <- data.frame(
 USUBJID = 1:10,
 EXTRT = rep(1,10),
 EXOCCUR = c(rep(1,2),rep(NA,4),rep(2,4)),
 EXDOSE = c(rep(NA,4),rep(1,6)),
 EXSTDTC = 1:10
)

EX$EXOCCUR[6]="NA"
EX$EXOCCUR[7]=""
EX$EXOCCUR[8]=NA

check_ex_exoccur_mis_exdose_nonmis(EX)

}
\author{
Iris Zhao
}
