% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lb_lbdtc_visit_ordinal_error.R
\name{check_lb_lbdtc_visit_ordinal_error}
\alias{check_lb_lbdtc_visit_ordinal_error}
\title{Check that all LB dates are duplicated or earlier than last
visit's (possible datetime data entry error)}
\usage{
check_lb_lbdtc_visit_ordinal_error(LB)
}
\arguments{
\item{LB}{SDTM dataset with variables USUBJID, VISITNUM, VISIT, LBDTC, LBTESTCD, LBSTAT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies LBDTC values that are duplicated or
earlier than last visit's. Records with LBSTAT == 'NOT DONE' and unscheduled
visits (VISIT with the string "UNSCHEDU") and treatment discon visits
(VISIT with the string "TREATMENT OR OBSERVATION FU COMP EARLY DISC") are excluded.
}
\examples{

# no case
LB1 <- data.frame(USUBJID = c(rep("101", 5), rep("102", 5)),
                LBCAT = "Hematology",
                LBDTC = rep(c(
                "2017-01-01T08:25",
                "2017-01-05T09:25",
                "2017-01-15T10:25",
                "2017-01-20T08:25",
                "2017-01-25T08:25"), 2),
                VISITNUM = rep(1:5,2),
                VISIT = rep(c(
                "Visit 1",
                "Visit 2",
                "Visit 3",
                "UNSCheduled!!!",
                "VIsit 5"), 2),
                LBSTAT = c(rep("", 9), "NOT DONE"),
                stringsAsFactors = FALSE)

check_lb_lbdtc_visit_ordinal_error(LB1)

LB2 = LB1
LB2$LBCAT = "Virology"
LB3 <- rbind(LB1, LB2)
check_lb_lbdtc_visit_ordinal_error(LB3)

# adding cases with earlier date
LB3$LBDTC[LB3$USUBJID == 101 & LB3$VISIT == "Visit 3"] <- "2016-01-10T08:25"
LB3$LBDTC[LB3$USUBJID == 102 & LB3$VISIT == "Visit 2"] <- "2016-01-01T06:25"
check_lb_lbdtc_visit_ordinal_error(LB = LB3)

# adding cases with duplicated date
LB3$LBDTC[LB3$USUBJID == 102 & LB3$VISIT == "Visit 3"] <- "2017-01-15T10:25"
LB3 <- LB3[order(LB3$USUBJID, LB3$VISITNUM, LB3$LBDTC),]
check_lb_lbdtc_visit_ordinal_error(LB = LB3)

# check if all NOT DONE
LB4 = LB3
LB4$LBSTAT = "NOT DONE"
check_lb_lbdtc_visit_ordinal_error(LB = LB4)

# check dropping a required variable
LB4$LBSTAT = NULL
check_lb_lbdtc_visit_ordinal_error(LB = LB4)

}
\author{
Simon Luo
}
