% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lb_lbstnrlo_lbstnrhi.R
\name{check_lb_lbstnrlo_lbstnrhi}
\alias{check_lb_lbstnrlo_lbstnrhi}
\title{Check for missing lab reference ranges (LBSTNRLO, LBSTNRHI)}
\usage{
check_lb_lbstnrlo_lbstnrhi(DM, LB)
}
\arguments{
\item{DM}{DM SDTM dataset with variable USUBJID, SITEID}

\item{LB}{Lab SDTM dataset with variables USUBJID, LBTEST, LBSTRESN, LBSTNRLO, LBSTNRHI}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing lab reference ranges (LBSTNRLO,
LBSTNRHI) in standard units when numeric result in standard unit (LBSTRESN)
is not missing and returns a data frame
}
\examples{

LB <- data.frame(
USUBJID = "1",
LBTEST = "Albumin",
LBSTRESN = 1:10,
LBSTNRLO = 1:10,
LBSTNRHI = 1:10,
stringsAsFactors=FALSE
)

LB$LBSTNRLO[1]=""
LB$LBSTNRLO[2]="NA"
LB$LBSTNRLO[3]=NA
LB$LBSTNRHI[3]=""
LB$LBSTNRHI[4]="NA"
LB$LBSTNRHI[5]=NA

DM <- data.frame(
USUBJID = "1",
SITEID = "123456",
stringsAsFactors=FALSE
)

check_lb_lbstnrlo_lbstnrhi(DM, LB)

}
\author{
Lei Zhao
}
