% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_oe_bcva_4m_late_early_tot.R
\name{check_oe_bcva_4m_late_early_tot}
\alias{check_oe_bcva_4m_late_early_tot}
\title{Check if 4m BCVA test stops too late, too early and has correct total}
\usage{
check_oe_bcva_4m_late_early_tot(OE)
}
\arguments{
\item{OE}{Ophtho Dataset with variables USUBJID, OESPID, OECAT, OESCAT, OETSTDTL, OESTRESN, OESTAT, OELOC, OELAT,
OERESCAT, VISIT, VISITNUM, OEDTC, OEDY}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This ophthalmology check is for BCVA 4m test. It checks three conditions: <1> BCVA test stops too late,
meaning that lines were read after number of correct letters is <= 3. <2> BCVA test stops too early, meaning that
further lines were not read when all numbers of correct letters is > 3. <3> BCVA total score is not correct, meaning
that the sum of the number of correct at 4 meters doesn't match with what has been recorded in eCRF
(BCVA Scores eCRF Page - A. Total number correct at 4m). Please note that this check only works with USUBJID, VISIT,
VISITNUM, OELOC, OELAT combination has unique dates (OEDTC). If your datasets are having situations like 1) unscheduled
visits happening on different dates or 2) BCVA TOTAL happens on a different date from BCVA row tests, such combinations
will be removed from check.
Please note that this check excludes forms BCVA Low Vision Test (BCV5), BCVA Scores (BCV7),
BCVA Low Luminance Scores (BCVLL5), BCVA Combined Assessments (BCVAC), BCVA Low Luminance Combined Assessments (BCVACLL)
before running check as these forms do not include Row numbers.
}
\examples{
OE_too_late <- data.frame(
  USUBJID = "1",
  OESPID = "FORMNAME-R:2/L:2XXXX",
  OECAT = "BEST CORRECTED VISUAL ACUITY",
  OETSTDTL = "TESTING DISTANCE: 4M",
  OESCAT = c(rep("", 6), "TOTAL"),
  OESTAT = "",
  OERESCAT = c("ROW 1 - SNELLEN 20/200", 
               "ROW 2 - SNELLEN 20/160", 
               "ROW 4 - SNELLEN 20/100",
               "ROW 3 - SNELLEN 20/125", 
               "ROW 5 - SNELLEN 20/80", 
               "ROW 6 - SNELLEN 20/63", 
               ""),
  VISIT = "WEEK 1",
  VISITNUM = 5,
  OEDTC = "2020-06-01",
  OEDY = 8,
  OELOC = "EYE",
  OELAT = "LEFT",
  OESTRESN = c(5, 5, 5, 4, 3, 2, 24)
)
check_oe_bcva_4m_late_early_tot(OE_too_late)

OE_too_early <- data.frame(
  USUBJID = "1",
  OESPID = "FORMNAME-R:2/L:2XXXX",
  OECAT = "BEST CORRECTED VISUAL ACUITY",
  OETSTDTL = "TESTING DISTANCE: 4M",
  OESCAT = c(rep("", 6), "TOTAL"),
  OESTAT = "",
  OERESCAT = c("ROW 1 - SNELLEN 20/200", 
               "ROW 2 - SNELLEN 20/160", 
               "ROW 4 - SNELLEN 20/100",
               "ROW 3 - SNELLEN 20/125", 
               "ROW 5 - SNELLEN 20/80", 
               "ROW 6 - SNELLEN 20/63", 
               ""),
  VISIT = "WEEK 1",
  VISITNUM = 5,
  OEDTC = "2020-06-01",
  OEDY = 8,
  OELOC = "EYE",
  OELAT = "LEFT",
  OESTRESN = c(5, 5, 5, 4, 4, 5, 28)
)
check_oe_bcva_4m_late_early_tot(OE_too_early)

OE_total_incorrect <- data.frame(
  USUBJID = "1",
  OESPID = "FORMNAME-R:2/L:2XXXX",
  OECAT = "BEST CORRECTED VISUAL ACUITY",
  OETSTDTL = "TESTING DISTANCE: 4M",
  OESCAT = c(rep("", 6), "TOTAL"),
  OESTAT = "",
  OERESCAT = c("ROW 1 - SNELLEN 20/200", 
               "ROW 2 - SNELLEN 20/160", 
               "ROW 4 - SNELLEN 20/100",
               "ROW 3 - SNELLEN 20/125", 
               "ROW 5 - SNELLEN 20/80", 
               "ROW 6 - SNELLEN 20/63", 
               ""),
  VISIT = "WEEK 1",
  VISITNUM = 5,
  OEDTC = "2020-06-01",
  OEDY = 8,
  OELOC = "EYE",
  OELAT = "LEFT",
  OESTRESN = c(5, 5, 5, 4, 4, 2, 28)
)
check_oe_bcva_4m_late_early_tot(OE_total_incorrect)




}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat_prior_ocular}()},
\code{\link{check_cm_cmlat}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_vs_1m_req}()},
\code{\link{check_oe_bcva_tot_mismatch}()},
\code{\link{check_oe_sc_lat_count_fingers}()},
\code{\link{check_pr_prlat}()},
\code{\link{check_sc_dm_eligcrit}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Rosemary Li (HackR 2021 Team Eye)
}
\concept{OPHTH}
\keyword{OPHTH}
