% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_oe_sc_lat_count_fingers.R
\name{check_oe_sc_lat_count_fingers}
\alias{check_oe_sc_lat_count_fingers}
\title{Check if Post Treatment Count Fingers in Study Eye laterality does not match with Subject Characteristics Study Eye laterality}
\usage{
check_oe_sc_lat_count_fingers(OE, SC)
}
\arguments{
\item{OE}{Ophthalmic Examination Dataset for Ophtho Study with variables USUBJID, OECAT, OELAT, VISIT, OEDTC, OETEST, OELOC, OESTAT (if present)}

\item{SC}{Subject Characteristics Dataset for Ophtho Study with variables USUBJID, SCTEST, SCTESTCD, SCCAT, SCORRES, SCDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
Check If Post Treatment Count Fingers in Study Eye is done on the actual Study eye by comparing laterality from OE domain with SC domain.
Check is ignored if Post Treatment Count Fingers is not collected in study as it is quite common for EP studies
}
\examples{

sc <- data.frame(USUBJID  = c(1,1,1,2,2,2),
                 SCTEST   = c("Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " "),
                 SCTESTCD = c("ELIGEYE", "FOCID", "", "ELIGEYE", "FOCID", ""),
                 SCCAT    = c("STUDY EYE SELECTION", "STUDY EYE SELECTION", "",
                              "STUDY EYE SELECTION", "STUDY EYE SELECTION", ""),
                 SCORRES  = c("LEFT", "OS", "", "RIGHT", "OD", ""),
                 SCDTC    = rep("2021-01-01", 6),
                 stringsAsFactors = FALSE)

oe <- data.frame(USUBJID = c(1,1,1,1,1,2,2,2,2,2,2),
                 OECAT  = rep("SAFETY ASSESSMENT OF LOW VISION", 11),
                 OELOC   = rep("Eye", 11),
                 OELAT   = c("LEFT", "Left", "left", "LEFT", "LEFT",
                             "RIGHT", "right", "right", "RIGHT", "RIGHT", "right"),
                 OEDY  = c(1, 28, 56, 84, 112, 1, 28, 56, 84, 112, 140),
                 VISIT   = c("Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 1", "Week 4", "Week 8", "Week 12", "Week 16", "Week 20"),
                 OEDTC = c("2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                           "2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                           "2021-06-01"),
                 OETEST = c("A", "B", "C", "D", "E", "A", "B", "C", "D", "E", "F"),
                 stringsAsFactors=FALSE)

check_oe_sc_lat_count_fingers(SC=sc, OE=oe)

sc <- data.frame(USUBJID  = c(1,1,1,2,2,2),
                 SCTEST   = c("Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " "),
                 SCTESTCD = c("ELIGEYE", "FOCID", "", "ELIGEYE", "FOCID", ""),
                 SCCAT    = c("STUDY EYE SELECTION", "STUDY EYE SELECTION", "",
                              "STUDY EYE SELECTION", "STUDY EYE SELECTION", ""),
                 SCORRES  = c("LEFT", "OS", "", "RIGHT", "OD", ""),
                 SCDTC    = rep("2021-01-01", 6),
                 stringsAsFactors = FALSE)

oe <- data.frame(USUBJID = c(1,1,1,1,1,2,2,2,2,2,2),
                 OECAT  = rep("SAFETY ASSESSMENT OF LOW VISION", 11),
                 OELOC   = rep("Eye", 11),
                 OELAT   = c("LEFT", "Left", "left", "LEFT", "right", "RIGHT",
                             "right", "right", "RIGHT", "RIGHT", "left"),
                 OEDY  = c(1, 28, 56, 84, 112, 1, 28, 56, 84, 112, 140),
                 VISIT   = c("Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 20"),
                 OEDTC = c("2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                           "2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                           "2021-06-01"),
                 OETEST = c("A", "B", "C", "D", "E", "A", "B", "C", "D", "E", "F"),
                 stringsAsFactors=FALSE)

check_oe_sc_lat_count_fingers(SC=sc, OE=oe)

sc <- data.frame(USUBJID  = c(1,1,1,2,2,2,3),
                 SCTEST   = c("Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Focus of Study-Specific Interest"),
                 SCTESTCD = c("ELIGEYE", "FOCID", "", "ELIGEYE", "FOCID", "", "FOCID"),
                 SCCAT    = c("STUDY EYE SELECTION", "STUDY EYE SELECTION", "",
                              "STUDY EYE SELECTION", "STUDY EYE SELECTION",
                              "", "STUDY EYE SELECTION"),
                 SCORRES  = c("LEFT", "OS", "", "RIGHT", "OD", "", "OS"),
                 SCDTC    = "2021-01-01",
                 stringsAsFactors = FALSE)

oe <- data.frame(USUBJID = c(1,1,1,1,1,2,2,2,2,2,2),
                 OESTAT  = c("","","","","","","","","","", "not DONE"),
                 OECAT  = "SAFETY ASSESSMENT OF LOW VISION",
                 OELOC   = "Eye",
                 OELAT   = c("LEFT", "Left", "left", "LEFT", "right", "RIGHT",
                             "right", "right", "RIGHT", "RIGHT", "left"),
                 OEDY  = c(1, 28, 56, 84, 112, 1, 28, 56, 84, 112, 140),
                 VISIT   = c("Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 20"),
                 OEDTC = c("2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                           "2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                           "2021-06-01"),
                 OETEST = c("A", "B", "C", "D", "E", "A", "B", "C", "D", "E", "F"),
                 stringsAsFactors=FALSE)

check_oe_sc_lat_count_fingers(SC=sc, OE=oe)

}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat_prior_ocular}()},
\code{\link{check_cm_cmlat}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_vs_1m_req}()},
\code{\link{check_oe_bcva_tot_mismatch}()},
\code{\link{check_pr_prlat}()},
\code{\link{check_sc_dm_eligcrit}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Monarch Shah (HackR 2021 Team Eye)
}
\concept{OPHTH}
\keyword{OPHTH}
