% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pr_prlat.R
\name{check_pr_prlat}
\alias{check_pr_prlat}
\title{Check if ocular procedures/surgeries has laterality missing for CRF pages which contain the word "OCULAR" (and not "NON-OCULAR").}
\usage{
check_pr_prlat(PR, preproc = identity, ...)
}
\arguments{
\item{PR}{Procedure/Surgery Dataset for Ophtho Study with variables USUBJID,
PRCAT, PRLAT, PRTRT, PROCCUR, PRPRESP, PRSPID (if Present),
PRSTDTC (if Present), PRINDC (if Present)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check assesses observations where PRCAT contains the word OCULAR and flags records with missing/inconsistent laterality
}
\examples{

PR <- data.frame(
   USUBJID = 1:5,
   PRCAT = "PRIOR OCULAR SURGERIES AND PROCEDURES",
   PRSTDTC = 1:5,
   PRLAT   = c("Left", "","Bilateral", "", ""),
   PRTRT   = c("A", "B", "A", "B", "A"),
   PROCCUR = c("Y", "N", "N", "Y", "Y"),
   PRPRESP = "Y",
   PRSPID  = "FORMNAME-R:2/L:2XXXX",
   stringsAsFactors = FALSE)
check_pr_prlat(PR,preproc=roche_derive_rave_row)

PR <- data.frame(
   USUBJID = 1:5,
   PRCAT = "CONCURRENT OCULAR PROCEDURE",
   PRSTDTC = 1:5,
   PRLAT   = c("Left", "LEFT","Bilateral", "RIGHT", "RIgHT"),
   PRTRT  = c("A", "B", "A", "B", "A"),
   PROCCUR = NA,
   PRPRESP = NA,
   stringsAsFactors = FALSE)
check_pr_prlat(PR)

PR <- data.frame(
   USUBJID = 1:5,
   PRCAT = "CONCURRENT OCULAR PROCEDURE",
   PRSTDTC = 1:5,
   PRLAT   = c("Left", "LEFT","Bilateral", "RIGHT", ""),
   PRTRT  = c("A", "B", "A", "B", "A"),
   PROCCUR = NA,
   PRPRESP = NA,
   stringsAsFactors = FALSE)
check_pr_prlat(PR)

PR <- data.frame(
   USUBJID = 1:5,
   PRCAT = "CONCURRENT OCULAR PROCEDURE",
   PRSTDTC = 1:5,
   PRLAT   = c("Left", "","Bilateral", "RIGHT", ""),
   PRTRT  = c("A", "B", "A", "B", "A"),
   PROCCUR = c("Y", "N", "N", "Y", "Y"),
   PRPRESP = "Y",
   stringsAsFactors = FALSE)
check_pr_prlat(PR)

PR <- data.frame(
   USUBJID = 1:5,
   PRCAT = c(rep("CONCURRENT NON-OCULAR PROCEDURE",3),rep("CONCURRENT OCULAR PROCEDURE",2)),
   PRSTDTC = 1:5,
   PRLAT   = c("", "","", "RIGHT", ""),
   PRTRT  = c("A", "B", "A", "B", "A"),
   PROCCUR = c("Y", "N", "N", "Y", "Y"),
   PRPRESP = "Y",
   stringsAsFactors = FALSE)
check_pr_prlat(PR)



}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat_prior_ocular}()},
\code{\link{check_cm_cmlat}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_vs_1m_req}()},
\code{\link{check_oe_bcva_tot_mismatch}()},
\code{\link{check_oe_sc_lat_count_fingers}()},
\code{\link{check_sc_dm_eligcrit}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Tim Barnett (HackR 2021 Team Eye) Monarch Shah (Added Concurrent Ocular Procedure in this check) (copied from check_cm_cmlat)
}
\concept{OPHTH}
\keyword{OPHTH}
