% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_qs_qsdtc_after_dd.R
\name{check_qs_qsdtc_after_dd}
\alias{check_qs_qsdtc_after_dd}
\title{Check for QS dates occurring after death date}
\usage{
check_qs_qsdtc_after_dd(AE, DS, QS)
}
\arguments{
\item{AE}{Adverse Event SDTM dataset with variables USUBJID,
AEDTHDTC, AESTDTC, AEDECOD, and AETERM}

\item{DS}{DS Disposition SDTM dataset with variables USUBJID,
DSSTDTC, DSDECOD, and DSTERM}

\item{QS}{Questionnaire Test Findings SDTM dataset with variables
USUBJID, QSDTC, QSCAT, and QSORRES}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check looks for QS dates that occur after death date
}
\examples{

AE <- data.frame(USUBJID = c(1,1,1,2,2,2),
                 AEDTHDTC = c("", "", "2016-01-01", "", "2016-01", "2016-01-01"),
                 AESTDTC = "2016-01-01",
                 AEDECOD = LETTERS[1:6],
                 AETERM = LETTERS[1:6],
                 stringsAsFactors = FALSE)

DS <- data.frame(USUBJID = c(1,1,1,2,2,2),
                 DSSTDTC = "2016-01-01",
                 DSDECOD = c("A", "B", "death", "AC", "BC", "death"),
                 DSTERM = letters[1:6],
                 stringsAsFactors = FALSE)

QS <- data.frame(USUBJID = c(1,1,1,2,2,2),
                 QSDTC   = c("2015-06-30", "2015-09-30", "2015-12-30",
                             "2015-06-30", "2015-09-30", "2015-12-30"),
                 QSCAT   = "A",
                 QSORRES =  LETTERS[1:6],
                 QSSTAT  = "",
                 VISIT  =  c("Week 1", "Week 12", "Week 24", "Week 1", "Week 12", "Week 24"),
                 QSSTRESC = LETTERS[1:6],
                 stringsAsFactors = FALSE)

check_qs_qsdtc_after_dd(AE, DS, QS)

QS$QSDTC[3:5] <- "2016-01-03"
check_qs_qsdtc_after_dd(AE, DS, QS)

QS$QSSTAT[3] <- "Not Done"
check_qs_qsdtc_after_dd(AE, DS, QS)

DS$DSSTDTC <- NULL
check_qs_qsdtc_after_dd(AE, DS, QS)

AE1 <- data.frame(USUBJID = 1,
                  AEDTHDTC = "",
                  AESTDTC = c("2015-11-01", "2016-02-01"),
                  AEDECOD = "Rash",
                  AETERM = "RASH",
                  stringsAsFactors = FALSE)

DS1 <- data.frame(USUBJID = 1,
                  DSSTDTC = "2016-01",
                  DSCAT = c("DISPOSITION EVENT", "OTHER"),
                  DSSCAT = c('STUDY COMPLETION/EARLY DISCONTINUATION', ''),
                  DSDECOD = "DEATH",
                  DSTERM = c("DEATH", "DEATH DUE TO PROGRESSIVE DISEASE"),
                  stringsAsFactors = FALSE)

QS1 <- data.frame(USUBJID = 1,
                  QSDTC   = c("2015-06-30", "2016-01-15", "2016-01-15"),
                  QSCAT   = rep("EQ-5D-5L"),
                  QSORRES = "1",
                  QSSTAT  = "",
                  VISIT  =  c("Week 1", "Week 12", "Week 12"),
                  QSSTRESC = "1",
                  stringsAsFactors = FALSE)

check_qs_qsdtc_after_dd(AE=AE1, DS=DS1, QS=QS1)

AE1$AEDTHDTC[1:2] <- "2015-07-01"
check_qs_qsdtc_after_dd(AE=AE1, DS=DS1, QS=QS1)
}
\author{
Monarch Shah
}
