% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_qs_qsstat_qsreasnd.R
\name{check_qs_qsstat_qsreasnd}
\alias{check_qs_qsstat_qsreasnd}
\title{Check to confirm that there is a reason for a questionnaire being marked as not done}
\usage{
check_qs_qsstat_qsreasnd(QS)
}
\arguments{
\item{QS}{Questionnaire SDTMv dataset with USUBJID, QSCAT, QSDTC, QSSTAT, QSREASND, VISIT (optional) variables}
}
\value{
boolean value if check returns 0 obs, otherwise return subset dataframe.
}
\description{
This code flags when QSSTAT Completion Status is marked as NOT DONE but QSREASND Reason Not Performed is not populated.
Some but not all questionnaires in a study may collect Reason Not Performed information, so there may be instances of
false positives in which no data correction is required. While QSREASND is a permissible variable, this scenario will be
flagged in P21.
}
\examples{

QS <- data.frame(USUBJID = c(1,1,1,2,2,2),
                 QSDTC   = c("2015-06-30", "2015-09-30", "2015-12-30", 
                             "2015-06-30", "2015-09-30", "2015-12-30"),
                 QSCAT   = "A",
                 VISIT  =  c("Week 1", "Week 12", "Week 24", "Week 1", "Week 12", "Week 24"),
                 QSSTAT  = c("Not Done","NOT DONE","not done", rep("",3)),
                 QSREASND = c("Reasons",rep("",5)),
                 stringsAsFactors = FALSE)

 check_qs_qsstat_qsreasnd(QS)

 QS$QSSTAT=NULL

 check_qs_qsstat_qsreasnd(QS)


}
\author{
Katie Patel, Bonita Viegas Monteiro, Tom Stone (HackR 2021 Team WeRawesome)
}
