% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_term_effectiveness}
\alias{plot_term_effectiveness}
\title{Plot Term Effectiveness Results}
\usage{
plot_term_effectiveness(
  term_analysis,
  plot_type = "precision_coverage",
  highlight_terms = NULL,
  title_override = NULL,
  show_values = TRUE
)
}
\arguments{
\item{term_analysis}{Result from term_effectiveness function}

\item{plot_type}{Type of plot to create ("precision_coverage", "counts", "comparison", "precision_only", "coverage_only")}

\item{highlight_terms}{Optional character vector of terms to highlight}

\item{title_override}{Optional custom title for the plot}

\item{show_values}{Logical, whether to show values on bars/points (default: TRUE)}
}
\value{
A ggplot object if ggplot2 is available, otherwise NULL with a message
}
\description{
Plot Term Effectiveness Results
}
\details{
This function creates visualizations of term effectiveness results with enhanced options
for creating individual, clean plots. New plot types include "precision_only" and
"coverage_only" for focused analysis.
}
\examples{
\donttest{
# Create sample data for demonstration
search_results <- data.frame(
  id = paste0("art", 1:10),
  title = c("Diabetes treatment", "Clinical trial", "Diabetes study",
            "Treatment options", "New therapy", "Glucose control",
            "Insulin therapy", "Management of diabetes", "Clinical study",
            "Therapy comparison"),
  abstract = c("This study examines diabetes treatments.",
               "A clinical trial on new treatments.",
               "Diabetes research findings.",
               "Comparison of treatment options.",
               "Novel therapy approach.",
               "Methods to control glucose levels.",
               "Insulin therapy effectiveness.",
               "Managing diabetes effectively.",
               "Clinical research protocols.",
               "Comparing therapy approaches.")
)

# Define search terms and gold standard
terms <- c("diabetes", "treatment", "clinical", "therapy")
gold_standard <- c("art1", "art3", "art7", "art8")

# First analyze term effectiveness
term_metrics <- term_effectiveness(terms, search_results, gold_standard)

# Create individual plots
precision_plot <- plot_term_effectiveness(term_metrics, "precision_only")
coverage_plot <- plot_term_effectiveness(term_metrics, "coverage_only")
bubble_plot <- plot_term_effectiveness(term_metrics, "precision_coverage")
}

}
