% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season-package.R
\docType{data}
\name{exercise}
\alias{exercise}
\title{Exercise Data from Queensland, 2005--2007}
\format{
A data frame with 1302 observations on the following 7 variables.
\describe{ \item{id}{subject number} \item{visit}{visit
number (1, 2 or 3)} \item{date}{date of interview (year-month-day)}
\item{year}{year of interview} \item{month}{month of
interview} \item{bmi}{body mass index at visit 1 (kg/m\eqn{^2})}
\item{walking}{walking time per week (in minutes) at each visit} }
}
\source{
From Prof Elizabeth Eakin and colleagues, The University of
Queensland, Brisbane.
}
\usage{
exercise
}
\description{
Exercise data in longitudinal format from a physical activity intervention
study in Logan, Queensland. Some subjects were lost to follow-up, so all
three visits are not available for all subjects.
}
\examples{

data(exercise)
boxplot(exercise$walking ~ exercise$month)

}
\references{
Eakin E, et al (2009) Telephone counselling for physical
activity and diet in type 2 diabetes and hypertension, \emph{Am J of Prev
Med}, vol 36, pages 142--9
}
\keyword{datasets}
