% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_df.R
\name{prepare_df}
\alias{prepare_df}
\title{Prepare Tidy Data Frame from Matched Lines}
\usage{
prepare_df(files, pattern, lines, path, relative_path, matches)
}
\arguments{
\item{files}{A character vector of files to search (only for \code{seek_in()}).}

\item{pattern}{A regular expression pattern used to match lines.}

\item{lines}{A list with \code{line_number} and \code{line}, as returned by \code{\link[=read_filter_lines]{read_filter_lines()}}.}

\item{path}{A character vector of one or more directories where files should be
discovered (only for \code{seek()}).}

\item{relative_path}{Logical. If TRUE, file paths are made relative to the
path argument. If multiple root paths are provided, relative_path is
automatically ignored and absolute paths are kept to avoid ambiguity.}

\item{matches}{Logical. If \code{TRUE}, all matches per line are also returned in a
\code{matches} list-column.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{path}: File path (relative if specified), marked with class \code{fs_path}.
\item \code{line_number}: Line number of the match within the file.
\item \code{match}: The first matched substring from the line.
\item \code{matches} (optional): All matched substrings as a list-column.
\item \code{line}: Full content of the matching line.
}
}
\description{
Constructs a tidy data frame from matched lines across a set of files.
This function takes the output of \code{\link[=read_filter_lines]{read_filter_lines()}} and returns one row per match,
including file path, line number, full line content, and regex match(es).
}
\details{
All steps are executed sequentially to transform file-based pattern matches into a structured tabular format.
The function assumes that input files and their corresponding line data are correctly aligned.
It handles path normalization, match extraction, and output column selection according to the \code{matches} and \code{relative_path} arguments.
}
\keyword{internal}
