% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrdData.R
\name{OrdData}
\alias{OrdData}
\title{Data ordering}
\usage{
OrdData(x, y, axis = 1, method = NA, ...)
}
\arguments{
\item{x}{explanatory matrix;}

\item{y}{community matrix;}

\item{axis}{the RDA axis in which the ordering should be based. Defaults to \code{axis=1}}

\item{method}{standardization method (described in \code{\link[vegan]{decostand}}) to be applied on y before the RDA analysis. If \code{NA} (default), no transformation is performed.}

\item{...}{furhter parameters passed to \code{\link[vegan]{decostand}} and \code{vegan::rda};}
}
\value{
An object of class \code{"ord"}, which is a list consisting of:
\enumerate{
\item{xo}: the ordered explanatory matrix
\item{yo}: the ordered community matrix (non-transformed)
\item{x}: the original explanatory matrix
\item{y}: the original community matrix
}
}
\description{
Ordinates both community and explanatory matrices based on the first RDA score.
}
\examples{
data(sim1)
sim1.o<-OrdData(x=sim1$envi, y=sim1$comm)
sim1.o<-OrdData(x=sim1$envi, y=sim1$comm, method="hellinger")
}
\author{
Danilo Candido Vieira
}
