% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{plot.smw}
\alias{plot.smw}
\alias{bgDP}
\alias{bgDP.dp}
\title{Plot the dissimilarity profiles}
\usage{
\method{plot}{smw}(x, w = NULL, sig = "z", z = 1.85, BPs = "max",
  seq.sig = 3, w.effect = F, values = c("zscore", "diss"),
  pchs = c(16, 16, 17), cols = c("black", "red", "blue"), bg = NULL,
  bg_alpha = 0.1, wcols = "rainbow", legend = TRUE, ...)

\method{bgDP}{dp}(dp)
}
\arguments{
\item{x}{An object of class \code{"smw"} resulted from the function \code{\link{SMW}}.}

\item{w}{The window size from which results will be plotted. Only effective if \code{length(smw)>1}.}

\item{sig}{Significance test for detecting dissimilarity values that differs significantly from those appearing in a random pattern. If \code{NULL} the significance test is ommited from the plot.The following tests are considered with default to \code{sig.test="z"}:
\itemize{
  \item \code{'z'} consider normalized dissimilarity (z-scores) discontinuities that exceed a "z" critical value;
  \item \code{'sd'} consider dissimilarity discontinuities that exceed mean plus one standard deviation;
  \item \code{'SD2'} consider dissimilarity discontinuities that exceed mean plus two standard deviation;
  \item \code{'tail1'} Consider dissimilarity discontinuities that exceed 95 percent confidence limits.
}}

\item{z}{The critical value for the significance of z-values. Defaults to \code{'z=1.85'} (Erdös et.al, 2014).}

\item{BPs}{Defines if the breakpoints should be chosen as those sample positions corresponding to the maximum dissimilarity in a sequence of significant values (\code{"max"}) or as those sample positions corresponding to the median position of the sequence (\code{"median"}). Defaults to \code{BPs="max"}. If \code{NULL} the breakpoints are not computed.}

\item{seq.sig}{The maximum length of consecutive, significant values of dissimilarity that will be considered in defining the community breakpoints. Defaults to \code{seq.sig=3};}

\item{w.effect}{Logical, if \code{TRUE} draws a  dissimilarity profile using different windows sizes and returns an invisible data.frame with the breakpoint frequencies. Only effective if \code{length(smw)>1}. The function uses \code{\link{extract}} with defaults parameters to define the breakpoint positions for each of the evaluated window sizes.}

\item{values}{Character. \code{"zscore"} for plotting z-scores, \code{"diss"} for plotting dissimilarity values.}

\item{pchs}{A numerical vector of the form \code{c(d,s,b)} which modifies the default symbols of the plot. The default \code{pch = c(16,16,17)} describes respectively the dissimilarity values, significant dissimilarity values and breakpoints.}

\item{cols}{Vector of length 3 specifying the colors of the plot in the same way as the pch argument. Defaults to \code{colors=c("black","red","blue")}.}

\item{bg}{Optional. Sets background colors according to the breakpoints. It can be expressed either by a vector of colors or by the name of a pallet function (e.g. \code{"rainbow"}).}

\item{bg_alpha}{Factor modifying the opacity alpha of the backgroud [0,1].}

\item{wcols}{Sets the colors for the window sizes (lines) when \code{w.effect=TRUE}. It can be expressed by a vector of colors or by the name of a pallet function. Defaults to \code{wcol="rainbow"} which uses the colour palette \code{rainbow} from R stats.}

\item{legend}{Logical. Should a default legend appear?}

\item{...}{Further graphical parameters.}

\item{dp}{An object of class \code{dp}.}
}
\value{
The function returns invisibly an object of class \code{"dp"} (see Details).
}
\description{
Plot results from \code{smw} and \code{dp} objects. The command is a shortcut for extracting and plotting \code{\link{SMW}} resuts. Auxiliary arguments from \code{\link{extract}} (i.e.  \code{sig}, \code{z}, \code{BPs} and \code{seq.sig}) can be passed to \code{plot.smw}.  The auxilary method \code{bgDP} is available for the returned \code{dp} object when the argument \code{bg} is not NULL (see Details).
}
\details{
If \code{bg} is not \code{NULL}, the attribute \code{params$bg} is added to the returned \code{dp}. This attribute contains the  sample colors used by the argument \code{bg}. The auxilary method \code{bgDP} can be used for accessing this color vector.
}
\examples{
data(sim1)
sim1o<-OrdData(sim1$envi,sim1$comm)
\dontshow{
pool<-SMW(yo=sim1o$yo,ws=c(40,50), n.rand=3)
plot(pool)
}
\donttest{
ws20<-SMW(yo=sim1o$yo,ws=20)
pool<-SMW(yo=sim1o$yo,ws=c(20,30,40))
plot(ws20)
plot(pool, w.effect=TRUE)
}
}
\seealso{
\code{\link{SMW}}, \code{\link{extract}}.
}
\author{
Danilo Candido Vieira
}
