% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_html.R
\name{safe_html}
\alias{safe_html}
\title{Safe html scrapping}
\usage{
safe_html(page, time = 60, attempts = 10)
}
\arguments{
\item{page}{requested URL}

\item{time}{sleep interval after each failure}

\item{attempts}{max number of tries (if there is a problem with connection)}
}
\value{
character vector
}
\description{
Function \code{safe_html} tries to download the URL several times.
}
\details{
Function \code{safe_html} performes 10 (by default) attempts to download the URL
and waits 60sec (by default) after each failure
}
\examples{
\dontrun{
page <- paste0('http://www.sejm.gov.pl/Sejm7.nsf/',
               'wypowiedz.xsp?posiedzenie=15&dzien=1&wyp=008')
safe_html(page)}

}
\author{
Przemyslaw Biecek
}

