% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selcorr.R
\name{selcorr}
\alias{selcorr}
\title{Post-Selection Inference for Generalized Linear Models}
\usage{
selcorr(
  object,
  fixed.vars = NULL,
  further.vars = NULL,
  boot.repl = 0,
  k = 2,
  conf.level = 0.95,
  quiet = FALSE
)
}
\arguments{
\item{object}{an object representing a model of an appropriate class.
This is used as the initial model in a (bidirectional) stepwise model selection.}

\item{fixed.vars}{the names of all independent variables that must be included
in the selected model. The default is none.}

\item{further.vars}{the names of all independent variables that can be included
in the selected model, but are not part of \code{object}. The default is none.}

\item{boot.repl}{a number or list of bootstrap replicates. The default is no bootstrapping.
See Details and Examples for clarification.}

\item{k}{the multiple of the number of degrees of freedom used as penalty in the model selection.
The default \code{k = 2} corresponds to the AIC.}

\item{conf.level}{the level of the confidence intervals.}

\item{quiet}{if \code{TRUE}, then \code{selcorr} does not generate an output.}
}
\value{
the selected model is returned, without correction for model-selection,
but with up to two additional components. There is an \code{output} component corresponding to
the post-selection inference, which is also printed unless \code{quiet = TRUE}.
When \code{boot.repl} is not \code{0}, there is also a \code{boot.repl} component
corresponding to the bootstrap replicates.
}
\description{
\code{selcorr} returns (unconditional) post-selection confidence intervals and p-values
for the coefficients of (generalized) linear models.
}
\details{
When \code{boot.repl = 0}, an approximate asymptotic distribution of the test statistic
is used to calculate p-values and calibrate the profile-likelihood confidence intervals.
This approach is faster, but p-values and confidence intervals can be more precisely calibrated
by parametrically bootstrapping the test statistic (with \code{boot.repl} the number of replicates).
Parallel computing can be used to speed up the bootstrapping: see Examples.
}
\examples{
## linear regression:
selcorr(lm(Fertility ~ ., swiss))

## logistic regression:
swiss.lr = within(swiss, Fertility <- (Fertility > 70))
selcorr(glm(Fertility ~ ., binomial, swiss.lr))

## parallel bootstrapping:
\dontrun{
library(future.apply)
plan(multisession)
boot.repl = future_replicate(8, selcorr(lm(Fertility ~ ., swiss), boot.repl = 1000,
                                        quiet = TRUE)$boot.repl, simplify = FALSE)
plan(sequential)
selcorr(lm(Fertility ~ ., swiss), boot.repl = do.call("rbind", boot.repl))}
}
