% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_si.R
\name{mixed_si}
\alias{mixed_si}
\title{Title Construction of selection index}
\usage{
mixed_si(data, traits, fixed, random, economic_values)
}
\arguments{
\item{data}{A data frame containing the fixed effects, random effects and traits}

\item{traits}{A character vector specifying trait names for which index has to be calculated}

\item{fixed}{The fixed effects}

\item{random}{The random effects}

\item{economic_values}{The relative economic values}
}
\value{
Results of selection index
}
\description{
Title Construction of selection index
}
\examples{
# Example dataset
data("data", package = "seliNDRIx", envir = environment())
traits <- c("tmy", "py", "fatyield")
fixed <- c("farm", "soc", "poc")
random <- c("sire")
economic_values <- c(1, 0.85, 0.65)
results <- mixed_si(data = data, traits = traits,
fixed = fixed, random = random, economic_values = economic_values)
}
