% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_mg.R
\docType{data}
\name{simple_med_mg}
\alias{simple_med_mg}
\title{Dataset (Simple Mediation Model, Two Groups)}
\format{
A data frame with 500 rows and four variables:
\describe{
\item{gp}{gp, the grouping variable}
\item{x}{x, the independent variable}
\item{m}{m, the mediator}
\item{y}{y, the dependent variable}
}
}
\usage{
simple_med_mg
}
\description{
Generated from a simple mediation model, n = 200, two groups,
n = 100 each.
}
\details{
This model is used for examples like this one:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(lavaan)
mod <- "m ~ x
        y ~ m"
fit <- sem(mod, simple_med_mg, gp = "group")
summary(fit)
}\if{html}{\out{</div>}}
}
\examples{

print(head(simple_med_mg), digits = 3)
nrow(simple_med_mg)
table(simple_med_mg$gp)

}
\keyword{datasets}
