% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubjData.R
\name{getSubjData}
\alias{getSubjData}
\title{Extract data from a subject level domain.}
\usage{
getSubjData(dbToken, animalList, domain, colList = NULL)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{animalList}{Mandatory, data.table.\cr
A table with the list of animals to be included in the output data.\cr
The table must include at least columns named 'STUDYID' and 'USUBJID'.}

\item{domain}{Mandatory, character, not case sensitive.\cr
The name of the domain table to extract data from.\cr
The name must be a subject level domain - i.e. a table including a 'USUBJID'
column.}

\item{colList}{Optional, character, not case sensitive.\cr
The list of columns to be extracted from the specified domain table.\cr
It can be a single string, a vector or a list of multiple strings.}
}
\value{
The function returns a data.table with all the rows for the animals
included in \code{animalList}.\cr
If no columns have been specified in \code{colList}, all the columns in
the table \code{colList} are included.\cr
If a list of columns have been specified in \code{colList}, these are
included. In addition, a set of columns are always included, whether they
are included in \code{colList} or not:
\itemize{
\item To ensure each row can be uniquely identified:
\itemize{
\item DOMAIN
\item STUDYID
\item USUBJID
\item POOLID (if it exists)
\item domainSEQ (if it exists)
}
\item For finding tables - to support age calculation and evaluation of
study phase:
\itemize{
\item domainDTC
\item domainDY
}
}
The order of the columns are as they are defined for the domain in the
SEND IG.\cr
The data table contains both
\itemize{
\item subject level data - i.e. rows where USUBJID is not empty
\item if applicable for the \code{domain}, pool level data - i.e. rows
where POOLID is not empty.\cr
In this case, all pools, which includes any of the subjects included in
\code{animalList}, are included
}
}
\description{
Extracts and returns all rows from the specified \code{domain} for the set
of subjects included in \code{animalList}.\cr
}
\examples{
\dontrun{
# Extract all columns from DM:
getSubjData(myDbToken, myControlAnimals, 'dm')

# Extract selected columns from LB:
getSubjData(myDbToken, myControlAnimals, 'LB',
            list('LBTESTCD', 'LBCAT',
                 'LBSTRESC', 'LBSTRESN', 'LBSTRESU',
                 'LBSTAT', 'LBREASND',
                 'LBTPT'))
}

}
