% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovb_plots.R
\name{add_bound_to_contour}
\alias{add_bound_to_contour}
\alias{add_bound_to_contour.lm}
\alias{add_bound_to_contour.fixest}
\alias{add_bound_to_contour.numeric}
\title{Add bounds to contour plot of omitted variable bias}
\usage{
add_bound_to_contour(...)

\method{add_bound_to_contour}{lm}(
  model,
  benchmark_covariates,
  kd = 1,
  ky = kd,
  bound_label = NULL,
  treatment = plot.env$treatment,
  reduce = plot.env$reduce,
  sensitivity.of = plot.env$sensitivity.of,
  label.text = TRUE,
  cex.label.text = 0.7,
  label.bump.x = plot.env$lim.x * (1/15),
  label.bump.y = plot.env$lim.y * (1/15),
  round = 2,
  ...
)

\method{add_bound_to_contour}{fixest}(
  model,
  benchmark_covariates,
  kd = 1,
  ky = kd,
  bound_label = NULL,
  treatment = plot.env$treatment,
  reduce = plot.env$reduce,
  sensitivity.of = plot.env$sensitivity.of,
  label.text = TRUE,
  cex.label.text = 0.7,
  label.bump.x = plot.env$lim.x * (1/15),
  label.bump.y = plot.env$lim.y * (1/15),
  round = 2,
  ...
)

\method{add_bound_to_contour}{numeric}(
  r2dz.x,
  r2yz.dx,
  bound_value = NULL,
  bound_label = NULL,
  label.text = TRUE,
  cex.label.text = 0.7,
  font.label.text = 1,
  label.bump.x = plot.env$lim.x * (1/15),
  label.bump.y = plot.env$lim.y * (1/15),
  round = 2,
  point.pch = 23,
  point.col = "black",
  point.bg = "red",
  point.cex = 1,
  point.font = 1,
  ...
)
}
\arguments{
\item{...}{arguments passed to other methods.}

\item{model}{An \code{lm} or \code{fixest} object with the outcome regression.}

\item{benchmark_covariates}{The user has two options: (i)  character vector of the names of covariates that will be used to bound the plausible strength of the unobserved confounders. Each variable will be considered separately; (ii) a named list with character vector names of covariates that will be used, \emph{as a group}, to bound the plausible strength of the unobserved confounders. The names of the list will be used for the benchmark labels. Note: for factor variables with more than two levels, you need to provide the name of each level as encoded in the \code{fixest} model (the columns of \code{model.matrix}).}

\item{kd}{numeric vector. Parameterizes how many times stronger the confounder is related to the treatment in comparison to the observed benchmark covariate.
Default value is \code{1} (confounder is as strong as benchmark covariate).}

\item{ky}{numeric vector. Parameterizes how many times stronger the confounder is related to the outcome in comparison to the observed benchmark covariate.
Default value is the same as \code{kd}.}

\item{bound_label}{label to bounds provided manually in \code{r2dz.x} and \code{r2yz.dx}.}

\item{treatment}{A character vector with the name of the treatment variable
of the model.}

\item{reduce}{should the bias adjustment reduce or increase the
absolute value of the estimated coefficient? Default is \code{TRUE}.}

\item{sensitivity.of}{should the contour plot show adjusted estimates (\code{"estimate"})
or adjusted t-values (\code{"t-value"})?}

\item{label.text}{should label texts be plotted? Default is \code{TRUE}.}

\item{cex.label.text}{size of the label text.}

\item{label.bump.x}{bump on the x coordinate of label text.}

\item{label.bump.y}{bump on the y coordinate of label text.}

\item{round}{integer indicating the number of decimal places to be used for rounding.}

\item{r2dz.x}{hypothetical partial R2 of unobserved confounder
Z with treatment D, given covariates X.}

\item{r2yz.dx}{hypothetical partial R2 of unobserved confounder Z
with outcome Y, given covariates X and treatment D.}

\item{bound_value}{value to be printed in label bound.}

\item{font.label.text}{font for the label text.}

\item{point.pch}{plotting character for \code{\link{points}}.}

\item{point.col}{color code or name for \code{\link{points}}.}

\item{point.bg}{background (fill) color for \code{\link{points}}.}

\item{point.cex}{size of \code{\link{points}}.}

\item{point.font}{font for \code{\link{points}}.}
}
\value{
The function adds bounds in an existing contour plot and returns `NULL`.
}
\description{
Convenience function to add bounds on a sensitivity contour plot created with \code{\link{ovb_contour_plot}}.
}
\examples{

# runs regression model
model <- lm(peacefactor ~ directlyharmed + age + farmer_dar + herder_dar +
                         pastvoted + hhsize_darfur + female + village,
                         data = darfur)
# contour plot
ovb_contour_plot(model = model, treatment = "directlyharmed")

# add bound 3/1 times stronger than female
add_bound_to_contour(model = model,
                     benchmark_covariates = "female",
                     kd = 3, ky = 1)

# add bound 50/2 times stronger than age
add_bound_to_contour(model = model,
                     benchmark_covariates = "age",
                     kd = 50, ky = 2)

}
