% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intra_influ_phylm.R
\name{intra_influ_phylm}
\alias{intra_influ_phylm}
\title{Interaction between intraspecific variability and influential species - Phylogenetic Linear Regression}
\usage{
intra_influ_phylm(
  formula,
  data,
  phy,
  Vy = NULL,
  Vx = NULL,
  y.transf = NULL,
  x.transf = NULL,
  n.intra = 10,
  distrib = "normal",
  model = "lambda",
  cutoff = 2,
  track = TRUE,
  ...
)
}
\arguments{
\item{formula}{The model formula:  \code{response~predictor}.}

\item{data}{Data frame containing species traits with row names matching tips
in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{Vy}{Name of the column containing the standard deviation or the standard error of the response 
variable. When information is not available for one taxon, the value can be 0 or \code{NA}.}

\item{Vx}{Name of the column containing the standard deviation or the standard error of the predictor 
variable. When information is not available for one taxon, the value can be 0 or \code{NA}}

\item{y.transf}{Transformation for the response variable (e.g. \code{"log"} or \code{"sqrt"}). Please use this 
argument instead of transforming data in the formula directly (see also details below).}

\item{x.transf}{Transformation for the predictor variable (e.g. \code{"log"} or \code{"sqrt"}). Please use this 
argument instead of transforming data in the formula directly (see also details below).}

\item{n.intra}{Number of datasets resimulated taking into account intraspecific variation (see: \code{"intra_phylm"})}

\item{distrib}{A character string indicating which distribution to use to generate a random value for the response 
and/or predictor variables. Default is normal distribution: "normal" (function \code{\link{rnorm}}).
Uniform distribution: "uniform" (\code{\link{runif}})
Warning: we recommend to use normal distribution with Vx or Vy = standard deviation of the mean.}

\item{model}{The phylogenetic model to use (see Details). Default is \code{lambda}.}

\item{cutoff}{The cutoff value used to identify for influential species
(see Details)}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phylolm}}
}
\value{
The function \code{intra_influ_phylm} returns a list with the following
components:

\code{cutoff}: The value selected for \code{cutoff}

\code{formula}: The formula

\code{full.model.estimates}: Coefficients, aic and the optimised
value of the phylogenetic parameter (e.g. \code{lambda}) for the full model
without deleted species.

\code{influential_species}: List of influential species, both
based on standardised difference in intercept and in the slope of the
regression. Species are ordered from most influential to less influential and
only include species with a standardised difference > \code{cutoff}.

\code{sensi.estimates}: A data frame with all simulation
estimates. Each row represents a deleted clade for an iteration of resimulated
data. Columns report the calculated regression intercept (\code{intercept}), 
difference between simulation intercept and full model intercept (\code{DIFintercept}), 
the standardised difference (\code{sDIFintercept}), the percentage of change in intercept compared
to the full model (\code{intercept.perc}) and intercept p-value
(\code{pval.intercept}). All these parameters are also reported for the regression
slope (\code{DIFestimate} etc.). Additionally, model aic value (\code{AIC}) and
the optimised value (\code{optpar}) of the phylogenetic parameter
(e.g. \code{kappa} or \code{lambda}, depending on the phylogenetic model used) are
reported.

\code{data}: Original full dataset.

\code{errors}: Species where deletion resulted in errors.
}
\description{
Performs leave-one-out deletion analysis for phylogenetic linear regression,
and detects influential species, while taking into account potential
interactions with intraspecific variability.
}
\details{
This function fits a phylogenetic linear regression model using \code{\link[phylolm]{phylolm}}, and detects
influential species by sequentially deleting one at a time. The regression is repeated \code{n.intra} times for 
simulated values of the dataset, taking into account intraspecific variation. At each iteration, the function 
generates a random value for each row in the dataset using the standard deviation or errors supplied, and 
detect the influential species within that iteration. 

All phylogenetic models from \code{phylolm} can be used, i.e. \code{BM},
\code{OUfixedRoot}, \code{OUrandomRoot}, \code{lambda}, \code{kappa},
\code{delta}, \code{EB} and \code{trend}. See ?\code{phylolm} for details.

\code{influ_phylm} detects influential species based on the standardised
difference in intercept and/or slope when removing a given species compared
to the full model including all species. Species with a standardised difference
above the value of \code{cutoff} are identified as influential. The default
value for the cutoff is 2 standardised differences change.

Currently, this function can only implement simple linear models (i.e. \eqn{trait~
predictor}). In the future we will implement more complex models.

Output can be visualised using \code{sensi_plot}.
}
\section{Warning}{
  
When Vy or Vx exceed Y or X, respectively, negative (or null) values can be generated, this might cause problems
for data transformation (e.g. log-transformation). In these cases, the function will skip the simulation. 

Setting \code{n.intra} at high values can take a long time to execute, since the total number of iterations 
equals \code{n.intra * nrow(data)}.
}

\examples{
\dontrun{
# Load data:
data(alien)
# run analysis:
intra_influ <- intra_influ_phylm(formula = gestaLen ~ adultMass, phy = alien$phy[[1]],
data=alien$data,model="lambda",y.transf = log,x.transf = NULL,Vy="SD_gesta",Vx=NULL,
n.intra=30,distrib = "normal")
summary(intra_influ)
sensi_plot(intra_influ)
}
\dontshow{
data(alien)
# run analysis:
intra_influ <- intra_influ_phylm(formula = gestaLen ~ adultMass, phy = alien$phy[[1]],
                                data=alien$data[1:15, ],model="lambda",y.transf = log,
                                x.transf = NULL,Vy="SD_gesta",Vx=NULL,
                                n.intra=5,distrib = "normal")
summary(intra_influ)
sensi_plot(intra_influ)
}
}
\references{
Paterno, G. B., Penone, C. Werner, G. D. A. 
\href{http://doi.wiley.com/10.1111/2041-210X.12990}{sensiPhy: 
An r-package for sensitivity analysis in phylogenetic 
comparative methods.} Methods in Ecology and Evolution 
2018, 9(6):1461-1467.  

Ho, L. S. T. and Ane, C. 2014. "A linear-time algorithm for 
Gaussian and non-Gaussian trait evolution models". Systematic Biology 63(3):397-408.
}
\seealso{
\code{\link[phylolm]{phylolm}}, \code{\link{intra_phylm}},
\code{\link{influ_phylm}},\code{\link{intra_influ_phyglm}},\code{\link{sensi_plot}}.
}
\author{
Gustavo Paterno, Caterina Penone & Gijsbert D.A. Werner
}
