% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.set}
\alias{sensibo.pod.set}
\title{Set the air conditioner (pod) state. NULL properties will be left unchanged. Please bear in mind that valid
values might depend of the A/C model.}
\usage{
sensibo.pod.set(pod, on = NULL, mode = NULL, fan = NULL,
  unit = NULL, temperature = NULL, swing = NULL,
  key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id.}

\item{on}{(logical) Set to TRUE to turn the pod on, FALSE to turn off instead.}

\item{mode}{(character) Set the mode from 'cool', 'hot', 'dry' and 'fan'}

\item{fan}{(character) Set the fan speed from 'low', 'medium', 'high' and 'auto'.}

\item{unit}{(character) Set the temperature unit: 'C' for Celsius, 'F' for Fahrenheit.}

\item{temperature}{(numeric) Set the target temperature}

\item{swing}{(character) Set the swing mode from 'stopped' and 'rangeFull'}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A list with the updated state and the result of the command (Success/Failure).
}
\description{
Set the air conditioner (pod) state. NULL properties will be left unchanged. Please bear in mind that valid
values might depend of the A/C model.
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Update the status of the first pod
pod.newstate <- sensibo.pod.set(pods.id[1], on = TRUE, mode = "cool", temperature = 26)
}
}
