% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.effects.R
\name{partdevs}
\alias{partdevs}
\alias{partdevs.bb}
\alias{partdevs.bc}
\alias{partdevs.cb}
\alias{partdevs.cc}
\title{Implementations of the partial derivatives (gradients) of the expressions for the direct, indirect and total effects. Used to calculate standard errors (delta method).}
\usage{
partdevs.bb(
  beta0,
  beta1,
  beta2,
  beta3,
  theta0,
  theta1,
  theta2,
  theta3,
  theta4,
  theta5,
  theta6,
  theta7,
  x.med,
  x.out,
  t.de,
  t.ie,
  exp.value,
  control.value
)

partdevs.bc(
  beta0,
  beta1,
  beta2,
  beta3,
  theta2,
  theta3,
  theta6,
  theta7,
  x.med,
  x.out,
  t.de,
  t.ie,
  exp.value,
  control.value
)

partdevs.cb(
  beta0,
  beta1,
  beta2,
  beta3,
  theta0,
  theta1,
  theta2,
  theta3,
  theta4,
  theta5,
  theta6,
  theta7,
  sigma.eta,
  x.med,
  x.out,
  t.de,
  t.ie,
  exp.value,
  control.value
)

partdevs.cc(
  beta0,
  beta1,
  beta2,
  beta3,
  theta2,
  theta3,
  theta6,
  theta7,
  exp.value,
  control.value,
  x.med,
  x.out,
  t.de,
  t.ie
)
}
\arguments{
\item{beta0, beta1}{Vectors of mediator regression parameters (intercept and exposure) over \code{Rho}}

\item{beta2, beta3}{Matrices of mediator regression parameters (covariate main effects and exposure-covariate interactions) over \code{Rho}}

\item{theta0, theta1, theta2, theta3}{Vectors of outcome regression parameters (intercept, exposure, mediator, exposure-mediator interaction) over \code{Rho}}

\item{theta4, theta5, theta6, theta7}{Matrices of outcome regression parameters (covariate main effects, exposure-covariate, mediator-covariate and exposure-mediator-covariate interactions) over \code{Rho}}

\item{x.med}{Mediator covariate matrix for which to calculate standard errors}

\item{x.out}{Outcome covariate matrix for which to calculate standard errors}

\item{t.de, t.ie}{exposure values used to calculate the direct and indirect effects depending on the desired decomposition (see the Details section of \code{\link{sensmediation}} for more information). If \code{alt.decomposition = TRUE} then \code{t.de = exp.value} and \code{t.ie = control.value}, otherwise \code{t.de = control.value} and \code{t.ie = exp.value}.}

\item{exp.value}{value of the exposure variable used as the exposure condition.}

\item{control.value}{value of the exposure variable used as the control (unexposed) condition.}

\item{sigma.eta}{For a continuous mediator and binary outcome, matrix with the estimated residual standard deviation for the mediator model over the range of \code{Rho}.}
}
\description{
Functions implementing the partial derivatives (gradients) of the expressions for the direct, indirect and total effects. These are then used
to calculate standard errors of the effects using the delta method. Called by the \code{\link{stderrs}} functions. The functions are named according to the convention
\code{partdevs."mediator model type""outcome model type"} where \code{b}stands for binary probit regression and
\code{c} stands for linear regression.
}
