% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars_matrices.R
\name{vars_matrices}
\alias{vars_matrices}
\title{STAR-VARS sampling strategy}
\usage{
vars_matrices(star.centers, params, h = 0.1, type = "QRN", ...)
}
\arguments{
\item{star.centers}{Positive integer, number of star centers.}

\item{params}{Character vector with the name of the model inputs.}

\item{h}{Distance between pairs. The user should select between 0.001, 0.002, 0.005, 0.01,
0.02, 0.05, 0.1, 0.2. Default is \code{h = 0.1}.}

\item{type}{Approach to construct the STAR-VARS. Options are:
\itemize{
\item \code{type = "QRN"}: It uses \insertCite{Sobol1967;textual}{sensobol} Quasi-Random Numbers
through a call to the function \code{\link[randtoolbox]{sobol}} of the \code{randtoolbox} package.
\item \code{type = "R"}: It uses random numbers.
}}

\item{...}{Further arguments in \code{\link[randtoolbox]{sobol}}.}
}
\value{
A matrix where each column is a model input and each row a sampling point.
}
\description{
It creates the STAR-VARS matrix needed to compute VARS-TO following \insertCite{Razavi2016a;textual}{sensobol}.
}
\details{
The user randomly selects \eqn{N_{star}} points across the factor space using
either Sobol' Quasi Random Numbers (\code{type = "QRN"}) or random numbers (\code{type = "R"}).
These are the \emph{star centres} and their location can be denoted as
\eqn{\mathbf{s}_v = s_{v_1},...,s_{v_i}, ..., s_{v_k}}, where \eqn{v=1,2,...,N_{star}}.
Then, for each star centre, the function generates a cross section of equally spaced points
\eqn{\Delta h} apart for each of the \eqn{k} model inputs, including and passing through the
star centre. The cross section is produced by fixing \eqn{\mathbf{s}_{v_{\sim i}}} and varying \eqn{s_i}.
Finally, for each factor all pairs of points with \eqn{h} values of \eqn{\Delta h, 2\Delta h, 3\Delta h}
and so on are extracted. The total computational cost of this design is
\eqn{N_t=N_{star} (k (\frac{1}{\Delta h} - 1) + 1)}.
}
\examples{
# Define settings
star.centers <- 10; params <- paste("X", 1:5, sep = ""); h <- 0.1

# Create STAR-VARS
mat <- vars_matrices(star.centers = star.centers, params = params, h = h)
}
\references{
\insertAllCited{}
}
