% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadixForest.R
\name{RadixForest}
\alias{RadixForest}
\title{RadixForest}
\description{
Radix Forest class implementation
}
\details{
The RadixForest class is a specialization of the RadixTree implementation. Instead of putting sequences into
a single tree, the RadixForest class puts sequences into separate trees based on sequence length. This allows for faster
searching of similar sequences based on Hamming or Levenshtein distance metrics.
Unlike the RadixTree class, the RadixForest class does not support anchored searches or a custom cost matrix.
See \emph{RadixTree} for additional details.
}
\examples{
forest <- RadixForest$new()
forest$insert(c("ACGT", "AAAA"))
forest$erase("AAAA")
forest$search("ACG", max_distance = 1, mode = "levenshtein")
 #   query target distance
 # 1   ACG   ACGT        1
 
forest$search("ACG", max_distance = 1, mode = "hamming")
 # query    target   distance
 # <0 rows> (or 0-length row.names)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{forest_pointer}}{Map of sequence length to RadixTree}

\item{\code{char_counter_pointer}}{Character count data for the purpose of validating input}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RadixForest-new}{\code{RadixForest$new()}}
\item \href{#method-RadixForest-show}{\code{RadixForest$show()}}
\item \href{#method-RadixForest-to_string}{\code{RadixForest$to_string()}}
\item \href{#method-RadixForest-graph}{\code{RadixForest$graph()}}
\item \href{#method-RadixForest-to_vector}{\code{RadixForest$to_vector()}}
\item \href{#method-RadixForest-size}{\code{RadixForest$size()}}
\item \href{#method-RadixForest-insert}{\code{RadixForest$insert()}}
\item \href{#method-RadixForest-erase}{\code{RadixForest$erase()}}
\item \href{#method-RadixForest-find}{\code{RadixForest$find()}}
\item \href{#method-RadixForest-prefix_search}{\code{RadixForest$prefix_search()}}
\item \href{#method-RadixForest-search}{\code{RadixForest$search()}}
\item \href{#method-RadixForest-validate}{\code{RadixForest$validate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-new"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-new}{}}}
\subsection{Method \code{new()}}{
Create a new RadixForest object
\subsection{Usage - new}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$new(sequences = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments - new}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sequences}}{A character vector of sequences to insert into the forest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-show"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-show}{}}}
\subsection{Method \code{show()}}{
Print the forest to screen
\subsection{Usage - show}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-to_string}{}}}
\subsection{Method \code{to_string()}}{
Print the forest to a string
\subsection{Usage - to_string}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$to_string()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-graph"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-graph}{}}}
\subsection{Method \code{graph()}}{
Plot of the forest using igraph
\subsection{Usage - graph}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$graph(depth = -1, root_label = "root", plot = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments - graph}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{depth}}{The tree depth to plot for each tree in the forest.}

\item{\code{root_label}}{The label of the root node(s) in the plot.}

\item{\code{plot}}{Whether to create a plot or return the data used to generate the plot.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns - graph}{
A data frame of parent-child relationships used to generate the igraph plot OR a ggplot2 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-to_vector"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-to_vector}{}}}
\subsection{Method \code{to_vector()}}{
Output all sequences held by the forest as a character vector
\subsection{Usage - to_vector}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$to_vector()}\if{html}{\out{</div>}}
}

\subsection{Returns - to_vector}{
A character vector of all sequences contained in the forest.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-size"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-size}{}}}
\subsection{Method \code{size()}}{
Output the size of the forest (i.e. how many sequences are contained)
\subsection{Usage - size}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$size()}\if{html}{\out{</div>}}
}

\subsection{Returns - size}{
The size of the forest
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-insert"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-insert}{}}}
\subsection{Method \code{insert()}}{
Insert new sequences into the forest
\subsection{Usage - insert}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$insert(sequences)}\if{html}{\out{</div>}}
}

\subsection{Arguments - insert}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sequences}}{A character vector of sequences to insert into the forest}
}
\if{html}{\out{</div>}}
}
\subsection{Returns - insert}{
A logical vector indicating whether the sequence was inserted (TRUE) or already existing in the forest (FALSE)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-erase"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-erase}{}}}
\subsection{Method \code{erase()}}{
Erase sequences from the forest
\subsection{Usage - erase}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$erase(sequences)}\if{html}{\out{</div>}}
}

\subsection{Arguments - erase}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sequences}}{A character vector of sequences to erase from the forest}
}
\if{html}{\out{</div>}}
}
\subsection{Returns - erase}{
A logical vector indicating whether the sequence was erased (TRUE) or not found in the forest (FALSE)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-find"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-find}{}}}
\subsection{Method \code{find()}}{
Find sequences in the forest
\subsection{Usage - find}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$find(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments - find}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{A character vector of sequences to find in the forest}
}
\if{html}{\out{</div>}}
}
\subsection{Returns - find}{
A logical vector indicating whether the sequence was found (TRUE) or not found in the forest (FALSE)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-prefix_search"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-prefix_search}{}}}
\subsection{Method \code{prefix_search()}}{
Search for sequences in the forest that start with a specified prefix.
E.g.: a query of "CAR" will find "CART", "CARBON", "CARROT", etc. but not "CATS".
\subsection{Usage - prefix_search}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$prefix_search(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments - prefix_search}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{A character vector of sequences to search for in the forest}
}
\if{html}{\out{</div>}}
}
\subsection{Returns - prefix_search}{
A data frame of all matches with columns "query" and "target".
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-search"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-search}{}}}
\subsection{Method \code{search()}}{
Search for sequences in the forest that are with a specified distance metric to a specified query.
\subsection{Usage - search}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$search(
  query,
  max_distance = NULL,
  max_fraction = NULL,
  mode = "levenshtein",
  nthreads = 1,
  show_progress = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments - search}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{A character vector of query sequences.}

\item{\code{max_distance}}{how far to search in units of absolute distance. Can be a single value or a vector. Mutually exclusive with max_fraction.}

\item{\code{max_fraction}}{how far to search in units of relative distance to each query sequence length. Can be a single value or a vector. Mutually exclusive with max_distance.}

\item{\code{mode}}{The distance metric to use. One of hamming (hm), global (gb) or anchored (an).}

\item{\code{nthreads}}{The number of threads to use for parallel computation.}

\item{\code{show_progress}}{Whether to show a progress bar.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns - search}{
The output is a data.frame of all matches with columns "query" and "target".
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RadixForest-validate"></a>}}
\if{latex}{\out{\hypertarget{method-RadixForest-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the forest
\subsection{Usage - validate}{
\if{html}{\out{<div class="r">}}\preformatted{RadixForest$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns - validate}{
A logical indicating whether the forest is valid (TRUE) or not (FALSE). This is mostly an internal function for debugging purposes and should always return TRUE.
}
}
}
