% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesizers.R
\name{getHarmonics}
\alias{getHarmonics}
\title{Harmonics sound sample}
\usage{
getHarmonics(
  freq,
  k,
  peak = 0.03,
  decay = 0.8,
  duration = 1,
  sustain = 0.25,
  type = "sine"
)
}
\arguments{
\item{freq}{Numeric, base frequency in Hz}

\item{k}{Integer >=1, kth harmonics}

\item{peak}{Numeric, peak time in seconds}

\item{decay}{Numeric, end-of-decay time in seconds}

\item{duration}{Numeric, total duration in seconds}

\item{sustain}{Numeric, sustain volume}

\item{type}{String, oscillator type, one of 'sine', 'saw', 'square' or 'triangle'.
If an unknowm string is provided, a sine oscillator will be used.}
}
\value{
An object of class 'soundSample'.
}
\description{
Creates a sound sample corresponding to the kth harmonics of a given frequency
}
\examples{
sam1 <- getHarmonics(440,1)
plot(sam1)
sam2 <- getHarmonics(440,3)
plot(sam2)
\dontrun{
# This line of code is wrapped in \dontrun{} since it relies
# on an external audio player to listen to the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
listen(sam2)}
}
