% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STBP-class.R
\docType{class}
\name{STBP-class}
\alias{STBP-class}
\title{Class "STBP". Result of a Sequential tests of Bayesian posterior probabilities}
\description{
This class encapsulates results of a Sequential tests of Bayesian posterior probabilities
}
\section{Slots}{

\describe{
\item{\code{call}}{(language) The call to \code{\link{stbp_simple}} or \code{\link{stbp_composite}}.}

\item{\code{probabilities}}{(numeric) Vector of sequential posterior probabilities.}

\item{\code{recommendation}}{(character) Recommendation on H, whether to accept, reject or keep sampling.}

\item{\code{iterations}}{(numeric) Number of sequential sampling bouts required or processed.}
}}

\examples{
set.seed(101)
counts3 <- rpois(5, lambda = 3)

test1F <- stbp_composite(data = counts3,
                          greater_than = TRUE,
                          hypothesis = 5,
                          density_func = "poisson",
                          prior = 0.5,
                          lower_bnd = 0,
                          upper_bnd = Inf,
                          lower_criterion = 0.001,
                          upper_criterion = 0.999)
test1F # returns "reject H".

counts10 <- matrix(rep(0, 30), 10, 3)

test1G <- stbp_simple(data = counts10,
                        density_func= "poisson",
                        prior = 0.5,
                        upper_bnd = Inf,
                        lower_criterion = 0,
                        upper_criterion = 0.9999)
test1G # returns "keep sampling" due to insufficient evidence.

## End (Not run)
}
