% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backlinks.R
\name{sst_bl_referring_domains}
\alias{sst_bl_referring_domains}
\title{Referring domains}
\usage{
sst_bl_referring_domains(
  domain,
  search_type = "domain",
  page = 1,
  size = 100,
  sort = "domain_rank",
  order = "desc",
  filter = NULL,
  return_method = "list",
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{domain}{(required) A domain name to analyze.}

\item{search_type}{(required) Default value is 'domain' for domain data only
(site.com). See API docs for more details.}

\item{page}{(optional) Response page number if there are many pages in response.
Default is 1.}

\item{size}{(optional) Response page size. Default is 100.}

\item{sort}{(optional) A field to sort the response. Default is
'domain_rank'. See API docs for more details.}

\item{order}{(optional)  The order of sorting. Default is 'desc' for
descending order. See API docs for more details.}

\item{filter}{(optional) The nested list of filtering options. See API docs
for more details.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns aggregated backlinks data for each referring domain.
}
\description{
Returns the list of referring domains with main backlinks metrics for each
domain.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/uhy05n77e38uy-get-ref-domains}{here}.
}

\section{API credits consumption}{
 1 per each domain in response.
}

\section{Sorting}{

  You can sort the response using \code{sort} argument. The sorting order is
  defined using \code{order} argument.
}

\examples{
\dontrun{
sst_bl_referring_domains(
  domain           = 'serpstat.com',
  page             = 1,
  size             = 100,
  sort             = 'domain_rank',
  order            = 'desc',
  filter           = NULL,
  return_method    = 'list'
)$data
}
}
