% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_curve.R
\name{sfc_2x2}
\alias{sfc_2x2}
\alias{sfc_3x3_peano}
\alias{sfc_3x3_meander}
\title{Create space-filling curves}
\usage{
sfc_2x2(seed, code = integer(0), rot = 0L)

sfc_3x3_peano(seed, code = integer(0), rot = 0L, level = NULL, flip = FALSE)

sfc_3x3_meander(seed, code = integer(0), rot = 0L, flip = FALSE)
}
\arguments{
\item{seed}{The seed sequence. In most cases, the seed sequence is a single base pattern, which can be specified as a single letter, then \code{rot} controls
the initial rotation of the base pattern. It also supports a sequence with more than one base patterns as the seed sequence. In this case,
it can be specified as a string of more than one base letters, then \code{rot} can be set to a single rotation scalar which controls the rotation of the
first letter, or a vector with the same length as the number of base letters.}

\item{code}{A vector of the expansion code. The left side corresponds to the top levels of the curve and the right side corresponds to the bottom level of the curve.
The value can be set as a vector e.g. \code{c(1, 2, 1)}, or as a string e.g. \code{"121"}, or as a number e.g. \code{121}.}

\item{rot}{Rotation of the seed sequence, measured in the polar coordinate system, in degrees.}

\item{level}{Specifically for \code{sfc_3x3_peano()}, since there is only one expansion code 1, it can also be generated by \code{rep(1, level)}.}

\item{flip}{Whether to use the "flipped" rules? For the Peano curve and the Meander curve, there is also a "fliiped" version
of curve expansion rules. On each level expansion in the Peano curve and the Meander curve, a point expands to nine points in
3x3 grids. Thus the value of \code{flip} can be set as a logical vector of length of nine that controls whether to use the flipped expansion
for the corresponding unit. Besides such "1-to-9" mode, \code{flip} can also be set as a function which acccepts the number of current points in the curve and return
a logical vector with the same length, i.e. the "all-to-all*9" mode.}
}
\value{
\itemize{
\item \code{sfc_hilbert()} returns an \code{sfc_2x2} object.
\item \code{sfc_peano()} returns an \code{sfc_3x3_peano} object.
\item \code{sfc_meander()} returns an \code{sfc_3x3_meander} object.
}

These three classes are child classes of \code{sfc_nxn}.
}
\description{
Create space-filling curves
}
\details{
\itemize{
\item \code{sfc_2x2()} generates the Hilbert curve from the seed sequence.
\item \code{sfc_3x3_peano()} generates the Peano curve from the seed sequence.
\item \code{sfc_3x3_meander()} generates the Meander curve from the seed sequence.
}
}
\examples{
sfc_2x2("I", "111") |> plot()
sfc_2x2("I", "111", rot = 90) |> plot()
sfc_2x2("IR", "111", rot = 90) |> plot()
sfc_3x3_peano("I", "111") |> plot()
sfc_3x3_peano("I", "111", 
    flip = c(FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE)) |> plot()
sfc_3x3_peano("IJ", "111") |> plot()

sfc_3x3_peano("I", level = 4, flip = function(p) {
    p@rot \%in\% c(90, 270)
}) |> plot(lwd = 1)

level = 4
sfc_3x3_peano("I", level = level, flip = function(p) {
     if(length(p) == 9^(level-1)) {
         l = rep(FALSE, length(p))
         ind = 1:9^2 + 9^2*rep(c(0, 2, 4, 6, 8), each = 9^2)
         l[ind] = p@rot[ind] \%in\% c(90, 270)

         ind = 1:9^2 + 9^2*rep(c(1, 3, 5, 7), each = 9^2)
         l[ind] = p@rot[ind] \%in\% c(0, 180)

         l
    } else {
         rep(FALSE, length(p))
    }
}) |> plot(lwd = 1)

sfc_3x3_meander("I", "111") |> plot()
sfc_3x3_meander("I", "111", 
    flip = c(TRUE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE)) |> plot()
sfc_3x3_meander("IR", "111") |> plot()
}
