% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbors.R
\name{st_nb_lag}
\alias{st_nb_lag}
\title{Pure Higher Order Neighbors}
\usage{
st_nb_lag(nb, order)
}
\arguments{
\item{nb}{A neighbor list object as created by \code{st_contiguity()}.}

\item{order}{The order of neighbors.}
}
\value{
a list of class \code{nb}
}
\description{
Identify higher order neighbors from a neighbor list. \code{order} must be greater than 1. When order equals 2 then the neighbors of the neighbors list is returned and so forth. See \href{https://spatialanalysis.github.io/handsonspatialdata/index.html}{Anselin's book} was: "https://spatial.uchicago.edu" "/sites/spatial.uchicago.edu/files/1_introandreview_reducedsize.pdf" for an example.
}
\details{
Utilizes \code{\link[spdep:nblag]{spdep::nblag()}}
}
\examples{
nb <- st_contiguity(sf::st_geometry(guerry))
st_nb_lag(nb, 3)
}
\seealso{
Other other: 
\code{\link{st_cardinalties}()},
\code{\link{st_nb_lag_cumul}()}
}
\concept{other}
