## -----------------------------------------------------------------------------
#| label: setup
#| echo: false
#| include: false

library(sf)
library(sfhotspot)
library(ggplot2)


## -----------------------------------------------------------------------------
#| echo: false
#| tbl-cap: "The included `memphis_robberies` dataset"

memphis_robberies


## -----------------------------------------------------------------------------
#| fig.alt: >
#|   A very basic point map showing the locations of individual robberies in
#|   Memphis, TN. Each robbery is represented as a small, semi-transparent dot.

ggplot(memphis_robberies) + 
  geom_sf(alpha = 0.1) + 
  theme_minimal()


## -----------------------------------------------------------------------------
point_counts <- hotspot_count(memphis_robberies)

point_counts


## -----------------------------------------------------------------------------
#| fig.alt: >
#|   A basic map showing the count of robberies in each cell in a grid covering
#|   Memphis, TN. Grid cells with more robberies are shown in darker shades of
#|   blue, while those with fewer robberies are shown in lighter shades.

ggplot() +
  geom_sf(
    mapping = aes(fill = n),
    data = point_counts,
    alpha = 0.75,
    colour = NA
  ) +
  scale_fill_distiller(direction = 1)


## -----------------------------------------------------------------------------
robbery_kde <- hotspot_kde(memphis_robberies)

robbery_kde


## -----------------------------------------------------------------------------
#| fig.alt: >
#|   A hotspot map showing the density of robberies in each cell in a grid 
#|   covering Memphis, TN. Grid cells with higher densitites of robberies are 
#|   shown in darker shades of blue, while those with lower densities are shown 
#|   in lighter shades.

ggplot() +
  geom_sf(
    mapping = aes(fill = kde),
    data = robbery_kde,
    alpha = 0.75,
    colour = NA
  ) +
  scale_fill_distiller(direction = 1)

