% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_to_randomized.R
\name{list_to_randomized}
\alias{list_to_randomized}
\title{list_to_randomized}
\usage{
list_to_randomized(list, observed = NULL)
}
\arguments{
\item{list}{List}

\item{observed}{Observed}
}
\value{
rd_pat, rd_ras
}
\description{
Convert list to rd_* object.
}
\details{
Convert list of randomized point pattern or raster layer to a rd_* object that
can be used with all functions of the package. The main purpose of this utility function
is to allow an easy parallelization of the randomization approach.

For more information, please see the "Parallelization" article.
}
\examples{
\dontrun{
fit_list <- lapply(X = 1:39, FUN = function(i) {fit_point_process(pattern = species_a,
n_random = 1, simplify = TRUE, return_input = FALSE, verbose = FALSE)})

list_to_randomized(list = fit_list, observed = species_a)
}

}
\seealso{
\code{\link{randomize_raster}},
\code{\link{translate_raster}},
\code{\link{reconstruct_pattern}}
}
