% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{shiny_input}
\alias{shiny_input}
\title{Create universal Shiny input binding}
\usage{
shiny_input(input_id, shiny_ui, value = NULL, type = "JSON")
}
\arguments{
\item{input_id}{String with name of this input. Access to this input within server code is normal with
input[[input_id]].}

\item{shiny_ui}{UI of HTML component presenting this input to the users. This UI should allow to extract its value
with jQuery $().val() function.}

\item{value}{An optional argument with value that should be set for this input. Can be used to store persisten input
valus in dynamic UIs.}

\item{type}{Type of input value (could be "JSON" or "text").}
}
\description{
Universal binding for Shiny input on custom user interface. Using this function one can create various inputs
ranging from text, numerical, date, dropdowns, etc. Value of this input is extracted via jQuery using $().val()
function and default exposed as serialized JSON to the Shiny server. If you want to change type of exposed input
value specify it via type param. Currently list of supported types is "JSON" (default) and "text".
}
\examples{
library(shiny)
library(shiny.semantic)
# Create a week field
uirender(
  tagList(
    div(class = "ui icon input",
        style = NULL,
        "",
        shiny_input(
          "my_id",
          tags$input(type = "week", name = "my_id", min = NULL, max = NULL),
          value = NULL,
          type = "text"),
        icon("calendar"))
  )
)

}
