% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkbox.R
\name{update_multiple_checkbox}
\alias{update_multiple_checkbox}
\alias{update_multiple_radio}
\title{Update checkbox Semantic UI component}
\usage{
update_multiple_checkbox(
  session = getDefaultReactiveDomain(),
  input_id,
  choices = NULL,
  choices_value = choices,
  selected = NULL,
  label = NULL
)

update_multiple_radio(
  session = getDefaultReactiveDomain(),
  input_id,
  choices = NULL,
  choices_value = choices,
  selected = NULL,
  label = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{input_id}{The id of the input object}

\item{choices}{All available options one can select from. If no need to update then leave as \code{NULL}}

\item{choices_value}{What reactive value should be used for corresponding choice.}

\item{selected}{The initially selected value.}

\item{label}{The label linked to the input}
}
\description{
Change the value of a \code{\link{multiple_checkbox}} input on the client.
}
\examples{
if (interactive()) {

library(shiny)
library(shiny.semantic)

ui <- function() {
  shinyUI(
    semanticPage(
      title = "Checkbox example",
      form(
        multiple_checkbox(
          "simple_checkbox", "Letters:", LETTERS[1:5], selected = c("A", "C"), type = "slider"
        )
      ),
      p("Selected letter:"),
      textOutput("selected_letter"),
      shiny.semantic::actionButton("simple_button", "Update input to D")
    )
  )
}

server <- shinyServer(function(input, output, session) {
  output$selected_letter <- renderText(paste(input[["simple_checkbox"]], collapse = ", "))

  observeEvent(input$simple_button, {
    update_multiple_checkbox(session, "simple_checkbox", selected = "D")
  })
})

shinyApp(ui = ui(), server = server)

}

}
