#'Collapses
#'
#' Collapse panels allow you to reduce clutter in your Shiny app by making 
#' panels of information that open and close with a user's click. Any type of
#' content can go in a collapse panel. Standard Bootstrap styling options are
#' available.
#'  
#'@section Components:
#' \describe{
#'  \item{\code{\link{bsCollapse}}}{A container for holder the individual panels created by \code{\link{bsCollapsePanel}}.}
#'  \item{\code{\link{bsCollapsePanel}}}{Creates an individual Collapse Panel that resides within a \code{\link{bsCollapse}}.}
#'  \item{\code{\link{updateCollapse}}}{Used within your server logic to open/close collapse panels or change their style.}
#'} 
#'
#'@details
#'Collapses are designed to mimic \code{\link[shiny:tabsetPanel]{tabsetPanel}} in their implementation. 
#'Start with \code{bsCollapse} to create a panel group, then fill it with panels
#'using \code{bsCollapsePanel}. 
#'
#'\code{bsCollapse} acts as an input, so you can retrieve which panels are open 
#'from the input object passed to the function in \code{\link[shiny:shinyServer]{shinyServer}}. 
#'
#'\code{updateCollapse} can be used within your server logic to open/close 
#'collapse panels or to change their style.
#'
#'@section Changes:
#'\code{style} is a new option that wasn't available in previous versions of 
#'shinyBS.
#'
#'@examples
#'library(shiny)
#'library(shinyBS)
#'
#'app = shinyApp(
#'  ui = 
#'  fluidPage(
#'    sidebarLayout(
#'      sidebarPanel(HTML("This button will open Panel 1 using <code>updateCollapse</code>."), 
#'                   actionButton("p1Button", "Push Me!"),
#'                   selectInput("styleSelect", "Select style for Panel 1", 
#'                    c("default", "primary", "danger", "warning", "info", "success"))
#'      ),
#'      mainPanel(
#'        bsCollapse(id = "collapseExample", open = "Panel 2",
#'                   bsCollapsePanel("Panel 1", "This is a panel with just text ",
#'                    "and has the default style. You can change the style in ",
#'                    "the sidebar.", style = "info"),
#'                   bsCollapsePanel("Panel 2", "This panel has a generic plot. ",
#'                    "and a 'success' style.", plotOutput("genericPlot"), style = "success")
#'        )
#'      )
#'    )
#'  ),
#'  server = 
#'  function(input, output, session) {
#'    output$genericPlot <- renderPlot(plot(rnorm(100)))  
#'    observeEvent(input$p1Button, ({
#'      updateCollapse(session, "collapseExample", open = "Panel 1")
#'    }))
#'    observeEvent(input$styleSelect, ({
#'      updateCollapse(session, "collapseExample", style = list("Panel 1" = input$styleSelect))
#'    }))
#'  }
#')
#'\dontrun{
#'  runApp(app)
#'}
#'@templateVar item_name Collapses
#'@templateVar family_name Collapses
#'@template footer
NULL
