% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_aggregator.R
\docType{class}
\name{max_aggregator}
\alias{max_aggregator}
\title{Aggregation using local maximum (absolute) values.}
\format{
An \code{R6::R6Class} object
}
\description{
Divide the data into small data ranges
and find the maximum (absolute) value of each.
It may be useful for the waveform data.
}
\examples{
data(noise_fluct)
agg <- max_aggregator$new(interleave_gaps = TRUE)
d_agg <- agg$aggregate(noise_fluct$time, noise_fluct$f500, 1000)
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines")

}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{max_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-max_aggregator-new}{\code{max_aggregator$new()}}
\item \href{#method-max_aggregator-clone}{\code{max_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-max_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-max_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{max_aggregator$new(..., interleave_gaps, coef_gap, NA_position, use_abs = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, coef_gap, NA_position, ...}}{Arguments pass to the constructor of \code{aggregator} object.}

\item{\code{use_abs}}{Logical. If \code{TRUE}, the absolute value is used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-max_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-max_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{max_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
