% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rms_max_aggregator.R
\docType{class}
\name{rms_max_aggregator}
\alias{rms_max_aggregator}
\title{Aggregation which returns the rms and maximum values
within small data ranges}
\format{
An \code{R6::R6Class} object
}
\description{
This aggregator divides the data into no-overlapping intervals
and calculate the root-mean-square and the maximum absolute
values of the data, which may be helpful to understand the waveforms.
}
\examples{
data(noise_fluct)
agg <- rms_max_aggregator$new(
  ylwr = min, y = mean, yupr = max, interleave_gaps = TRUE
)
d_agg <- agg$aggregate(nanotime::as.nanotime(noise_fluct$time), noise_fluct$f500, 100)
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines") \%>\%
  plotly::add_trace(x = d_agg$x, y = d_agg$ylwr, type = "scatter", mode = "lines")\%>\%
  plotly::add_trace(x = d_agg$x, y = d_agg$yupr, type = "scatter", mode = "lines")

}
\section{Super classes}{
\code{shinyHugePlot::aggregator} -> \code{shinyHugePlot::rng_aggregator} -> \code{rms_max_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rms_max_aggregator-new}{\code{rms_max_aggregator$new()}}
\item \href{#method-rms_max_aggregator-clone}{\code{rms_max_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="rng_aggregator" data-id="as_plotly_range"><a href='../../shinyHugePlot/html/rng_aggregator.html#method-rng_aggregator-as_plotly_range'><code>shinyHugePlot::rng_aggregator$as_plotly_range()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="rng_aggregator" data-id="as_range"><a href='../../shinyHugePlot/html/rng_aggregator.html#method-rng_aggregator-as_range'><code>shinyHugePlot::rng_aggregator$as_range()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rms_max_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-rms_max_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rms_max_aggregator$new(
  ...,
  interleave_gaps,
  coef_gap,
  NA_position,
  use_abs = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, coef_gap, NA_position, ...}}{Arguments pass to the constructor of \code{aggregator} object.}

\item{\code{use_abs}}{Boolean. If `TRUE`, the maximum absolute values are calculated.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rms_max_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rms_max_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rms_max_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
