% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flGripDialInput-binding.R
\name{touchGripKnobInput}
\alias{touchGripKnobInput}
\title{Highly configurable, touch-enabled grip dial knob input for Shiny}
\usage{
touchGripKnobInput(
  inputId,
  label = NULL,
  labelPosition = "top",
  width = "auto",
  step = "any",
  min = 0,
  max = 1,
  initial = 0.5,
  color = "orange",
  guideTicks = 9,
  gripBumps = 5,
  gripExtrusion = 0.5,
  minRotation = 20,
  maxRotation = 340,
  dragResistance = 100,
  wheelResistance = 100,
  globalRatePolicy = NULL,
  globalRatePolicyDelay = 500
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Optional label for knob}

\item{labelPosition}{Position of label ('top' or 'bottom')}

\item{width}{Width of the knob as a percentage of the container element}

\item{step}{The step amount for value changes, usually used with min and max parameters. Can be 'any' (no step)}

\item{min}{The minimum input value.}

\item{max}{The maximum input value.}

\item{initial}{Initial value of the knob. Knob resets to this value when double-clicked.}

\item{color}{The color to use for the focus indicator and indicator dot. You can set any *hex* color (ex : '#0F1BC3') or named color, choices are 'purple', 'blue', 'green', 'yellow', 'red', 'orange' or 'transparent' to disable.}

\item{guideTicks}{Number of tick marks on the outer guide ring (default = 9)}

\item{gripBumps}{Number of grip bumps that appear when interacting with the dial (default = 5)}

\item{gripExtrusion}{The degree to which the grips 'cut' into the dial when the user interacts with it. (range 0 to 1, default = 0.5)}

\item{minRotation}{The angle (in degrees) of rotation corresponding to the min value, relative to pointing straight down (0 degree) (default = pointing to the first guide tick mark)}

\item{maxRotation}{The angle (in degrees) of rotation corresponding to the max value, relative to pointing straight down (0 degree) (default = pointing to the last guide tick mark)}

\item{dragResistance}{The amount of resistance to value change on mouse/touch drag events. Higher value means more precision, and the user will have to drag farther to change the input's value. (0 to 100)}

\item{wheelResistance}{The amount of resistance to value change on mouse wheel scroll. Higher value means more precision, and the mouse wheel will be less effective at changing the input's value. (0 to 100)}

\item{globalRatePolicy}{Rate policy determining the behavior of output value events. NULL will output values in real-time, 'debounce' will output values once the knob stops moving, 'throttle' will output values while the knob is moving but only at a certain frequency (controlled with ratePolicyDelay). This setting will affect every touchKnobInput in the project.}

\item{globalRatePolicyDelay}{Delay to use when globalRatePolicy is set to 'throttle' or 'debounce'. This setting will affect every touchKnobInput in the project.}
}
\value{
Numeric value server-side.
}
\description{
Highly configurable, touch-enabled grip dial knob input for Shiny
}
\examples{
if (interactive()) {

library("shiny")
library("shinyKnobs")

ui <- fluidPage(
  touchGripKnobInput(
    inputId = "myKnob",
    width = "25\%",
    label = "A label...",
    color = "#428BCA"
  ),
  verbatimTextOutput(outputId = "res")
)

server <- function(input, output, session) {

  output$res <- renderPrint(input$myKnob)

}

shinyApp(ui = ui, server = server)

}
}
