% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_button.R
\name{lottie_button}
\alias{lottie_button}
\title{Convert a 'Lottie' Animation to a Button}
\usage{
lottie_button(
  animation,
  inputId,
  label = NULL,
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{animation}{A 'Lottie' animation created by \code{\link{lottie_animation}}.}

\item{inputId}{The 'shiny' \code{input} slot that will be used to access the value.}

\item{label}{Optional text label to display below the animation inside the button.}

\item{width}{Width of the button. This is validated using \code{\link[htmltools:validateCssUnit]{validateCssUnit}}.}

\item{height}{Height of the button. This is validated using \code{\link[htmltools:validateCssUnit]{validateCssUnit}}.}

\item{...}{Additional named attributes to pass to the button element. Same behaviour as \code{\link[shiny:actionButton]{actionButton}}.}
}
\value{
An HTML button element enclosing the \code{animation} input object.
}
\description{
Wraps a 'Lottie' animation within a button element for use in 'shiny' applications.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation",
    height = "100px",
    width = "100px"
  ) |> lottie_button(inputId = "my_button")
)

server <- function(input, output, session) {
  observeEvent(input$my_button, {
    print("Button pressed")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
