% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{textarea}
\alias{textarea}
\alias{textarea_input}
\alias{update_textarea_input}
\title{textarea}
\usage{
textarea_input(inputId, ..., value = default_value)

update_textarea_input(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI textarea component.
}
\description{
Textarea component is a multi-line Input which allows you to write large texts.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{minRows}. Type: \code{number}. Default: \code{"3"}.
\item \bold{maxRows}. Type: \code{number}. Default: \code{"8"}.
\item \bold{cacheMeasurements}. Type: \code{boolean}. Default: \code{false}.
\item \bold{variant}. Type: \code{flat OR bordered OR faded OR underlined}. Default: \code{"flat"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{NA}.
\item \bold{label}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{value}. Type: \code{string}. Default: \code{NA}.
\item \bold{defaultValue}. Type: \code{string}. Default: \code{NA}.
\item \bold{placeholder}. Type: \code{string}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{description}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{errorMessage}. Type: \code{ReactNode OR ((v: ValidationResult) => ReactNode)}. Default: \code{NA}.
\item \bold{validate}. Type: \code{(value: string) => ValidationError OR true OR null OR undefined}. Default: \code{NA}.
\item \bold{validationBehavior}. Type: \code{native OR aria}. Default: \code{"native"}.
\item \bold{labelPlacement}. Type: \code{inside OR outside OR outside-left}. Default: \code{"inside"}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{true}.
\item \bold{isRequired}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isReadOnly}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isClearable}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isInvalid}. Type: \code{boolean}. Default: \code{false}.
\item \bold{validationState}. Type: \code{valid OR invalid}. Default: \code{NA}.
\item \bold{disableAutosize}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "label" OR "inputWrapper" OR "innerWrapper" OR "input" OR "description" OR "errorMessage", string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onChange}. Type: \code{React.ChangeEvent<HTMLInputElement>}. Default: \code{NA}.
\item \bold{onValueChange}. Type: \code{(value: string) => void}. Default: \code{NA}.
\item \bold{onClear}. Type: \code{() => void}. Default: \code{NA}.
\item \bold{onHeightChange}. Type: \code{(height: number, meta: { rowHeight: number }) => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)

ui <- nextui_page(
  div(
    class = "flex gap-5",
    action_button("update_text", "Update text"),
    textarea_input(
      inputId = "textarea",
      placeholder = "Enter your amazing ideas.",
      label = "Text area input",
      bordered = TRUE,
      color = "secondary",
      status = "secondary",
      helperColor = "error",
      helperText = "Click on update text"
    )
  ),
  textOutput("textarea_val")
)

server <- function(input, output, session) {
  output$textarea_val <- renderText(input$textarea)

  observeEvent(input$update_text, {
    update_textarea_input(
      inputId = "textarea",
      value = "Updated value"
    )
  })
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/textarea}.
}
