% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XYpad.R
\name{XYpadInput}
\alias{XYpadInput}
\title{XY pad controller}
\usage{
XYpadInput(
  inputId,
  label = NULL,
  value = list(x = 50, y = 50),
  xmin = 0,
  xmax = 100,
  ymin = 0,
  ymax = 100,
  ndecimals = 2,
  width = 200,
  height = 200,
  bgColor = "rgba(255,200,200,0.2)",
  xyColor = "blue",
  xySize = 11,
  xyStyle = "italic",
  coordsColor = xyColor,
  pointColor = "#16235a",
  pointRadius = 5,
  border = "2px solid #777CA8",
  x = "x",
  y = "y",
  displayPrevious = TRUE,
  displayXY = TRUE,
  onMove = FALSE
)
}
\arguments{
\item{inputId}{the input slot that will be used to access the value}

\item{label}{label for the XY pad, or \code{NULL} for no label}

\item{value}{the initial value, a list of two numbers named \code{"x"} and \code{"y"}}

\item{xmin, xmax}{minimal x-value and maximal x-value}

\item{ymin, ymax}{minimal y-value and maximal y-value}

\item{ndecimals}{number of decimals of the displayed coordinates (if \code{displayXY=TRUE})}

\item{width}{a positive number, the width in pixels}

\item{height}{a positive number, the height in pixels}

\item{bgColor}{background color, a HTML color; you have to set some transparency
in order to see the coordinates}

\item{xyColor}{color of the labels of the coordinates (if \code{displayXY=TRUE}), a HTML color}

\item{xySize}{font size of the labels of the coordinates (if \code{displayXY=TRUE})}

\item{xyStyle}{font style of the labels of the coordinates (if \code{displayXY=TRUE}),
\code{"normal"}, \code{"italic"} or \code{"oblique"}}

\item{coordsColor}{color of the displayed coordinates (if \code{displayXY=TRUE}), a HTML color}

\item{pointColor}{color of the point, a HTML color}

\item{pointRadius}{radius of the point in pixels}

\item{border}{CSS for the border of the XY pad}

\item{x}{label of the x-coordinate (if \code{displayXY=TRUE})}

\item{y}{label of the y-coordinate (if \code{displayXY=TRUE})}

\item{displayPrevious}{logical, whether to display the previous position of the point}

\item{displayXY}{logical, whether to display the coordinates}

\item{onMove}{logical, whether to send value to server on mouse move
(\code{TRUE}) or on mouse release (\code{FALSE})}
}
\value{
A \code{shiny.tag.list} object generating a XY pad input control that
  can be added to a Shiny UI definition.
}
\description{
Creates a XY pad controller to be included in a Shiny UI.
}
\examples{
library(shiny)
library(shinyXYpad)
ui <- fluidPage(
  fluidRow(
    column(
      6,
      XYpadInput("xy1", onMove = TRUE, label = "XY pad - on move")
    ),
    column(
      6,
      XYpadInput(
        "xy2", label = "XY pad - on release",
        displayXY = FALSE, displayPrevious = FALSE
      )
    )
  ),
  fluidRow(
    column(6, verbatimTextOutput("xy1value")),
    column(6, verbatimTextOutput("xy2value"))
  )
)
server <- function(input, output, session){
  output[["xy1value"]] <- renderPrint({ input[["xy1"]] })
  output[["xy2value"]] <- renderPrint({ input[["xy2"]] })
}

if(interactive()){
  shinyApp(ui, server)
}
}
\seealso{
\code{\link{updateXYpadInput}} for updating the XY pad on server-side.
}
