% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aDataScene.R
\name{aDataScene}
\alias{aDataScene}
\title{A-Frame Scene with R data}
\usage{
aDataScene(data, elementId = NULL)
}
\arguments{
\item{data}{A data frame or a list of vectors, matrices, and/or data frames}

\item{elementId}{Optionally define the output HTML element \code{id}}
}
\description{
Create an HTML widget to sync R data with an A-Frame
scene via the data-binding A-Frame component.
}
\details{
Data will be synced to the \code{data-binding} system from the
\href{https://www.npmjs.com/package/gg-aframe}{gg-aframe} JavaScript
library for A-Frame. Data can be bound to automatically update components
in the scene with the \code{data-binding} A-Frame component. Repeat
calls (e.g. within a Shiny reactive expression) will update the
\code{data-binding} store and refresh bound components with the new data.

If \code{data} is a data frame, each variable will be available, by name,
as a JavaScript Array in the scene data store (i.e. long form).
If it is a list, each list item will be available, by name, as a
JavaScript Array in the scene data store. Data frames within the list
will be available as an array of Objects, with each object
representing a row from the data frame (i.e. wide form).

To send multiple data frames in long form, combine them with
\code{c}, and each column will be available by name
in the A-Frame \code{data-binding} system. To send multiple
data frames in wide form, combine them as named items in
a \code{list}, and each data frame will be available as an array of
objects (rows) under the name used.

Note: \code{aDataScene} is only compatible for use in Shiny
apps viewed with a modern Web browser and internet connection.
WebVR data visualizations are not available in Rmd documents, R Notebooks,
or the RStudio Viewer at this time.
}
\examples{
library(dplyr)
library(scales)

# Execute within a renderADataScene call in a Shiny server
iris \%>\%
  # scale positional data to (0,1)
  mutate_if(is.numeric, rescale) \%>\%
  # make data available in JavaScript
  aDataScene()

}
\seealso{
\code{\link{renderADataScene}}
}

