% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_app.R
\name{delete_app}
\alias{delete_app}
\title{Deletes an app from the database}
\usage{
delete_app(appName, shinyMgrPath, fileDelete = FALSE)
}
\arguments{
\item{appName}{The name of the app to be deleted}

\item{shinyMgrPath}{The path to the shinymgr project. Typically the working 
directory.}

\item{fileDelete}{TRUE/FALSE, whether the app script should also be deleted 
- defaults to FALSE.}
}
\value{
An integer value with the total number of rows deleted (including 
cascades)
}
\description{
Deletes an app (and associated files if requested) from the 
shinymgr.sqlite database
}
\section{More Info}{

The delete_app() function is described in the "app_modules" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other delete: 
\code{\link{delete_mod}()},
\code{\link{delete_report}()}
}
\concept{delete}
