% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_shinymgr.R
\name{launch_shinymgr}
\alias{launch_shinymgr}
\title{Launch the master app for shinymgr}
\usage{
launch_shinymgr(shinyMgrPath, ...)
}
\arguments{
\item{shinyMgrPath}{Filepath to the main shinymgr folder.}

\item{...}{Additional arguments to be passed to the app.}
}
\value{
No return value, function launches shiny app
}
\description{
Launches the master app for shinymgr
}
\section{More Info}{

The launch_shinymgr() function is described in the "shinymgr" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  
  # set the directory path that will house the shinymgr project
  parentPath <- tempdir()
  shinyMgrPath <- paste0(parentPath, '/shinymgr')

  # set up raw directories and fresh database
  shinymgr_setup(parentPath, demo = TRUE)
  
  # The shiny app
  launch_shinymgr(shinyMgrPath)

  # Accepts args to shiny::runApp
  launch_shinymgr(shinyMgrPath, quiet = TRUE)
  
  # remove demo
  unlink(shinyMgrPath, recursive = TRUE)

}

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\keyword{misc}
